// Ported from js-yaml v3.13.1:
// https://github.com/nodeca/js-yaml/commit/665aadda42349dcae869f12040d9b10ef18d12da
// Copyright 2011-2015 by Vitaly Puzrin. All rights reserved. MIT license.
// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
import { State } from "../_state.ts";
const { hasOwn } = Object;
function compileStyleMap(schema, map) {
  if (typeof map === "undefined" || map === null) return {};
  const result = {};
  for (let tag of Object.keys(map)){
    let style = String(map[tag]);
    if (tag.slice(0, 2) === "!!") {
      tag = `tag:yaml.org,2002:${tag.slice(2)}`;
    }
    const type = schema.compiledTypeMap.fallback[tag];
    if (type && typeof type.styleAliases !== "undefined" && hasOwn(type.styleAliases, style)) {
      style = type.styleAliases[style];
    }
    result[tag] = style;
  }
  return result;
}
export class DumperState extends State {
  indent;
  noArrayIndent;
  skipInvalid;
  flowLevel;
  sortKeys;
  lineWidth;
  noRefs;
  noCompatMode;
  condenseFlow;
  implicitTypes;
  explicitTypes;
  tag = null;
  result = "";
  duplicates = [];
  usedDuplicates = [];
  styleMap;
  dump;
  constructor({ schema, indent = 2, noArrayIndent = false, skipInvalid = false, flowLevel = -1, styles = null, sortKeys = false, lineWidth = 80, noRefs = false, noCompatMode = false, condenseFlow = false }){
    super(schema);
    this.indent = Math.max(1, indent);
    this.noArrayIndent = noArrayIndent;
    this.skipInvalid = skipInvalid;
    this.flowLevel = flowLevel;
    this.styleMap = compileStyleMap(this.schema, styles);
    this.sortKeys = sortKeys;
    this.lineWidth = lineWidth;
    this.noRefs = noRefs;
    this.noCompatMode = noCompatMode;
    this.condenseFlow = condenseFlow;
    this.implicitTypes = this.schema.compiledImplicit;
    this.explicitTypes = this.schema.compiledExplicit;
  }
}
//# sourceMappingURL=data:application/json;base64,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
// denoCacheMetadata=13446561272594019322,11873857816251400255