// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
/**
 * Helpers for interacting with Deno's permissions system.
 *
 * @deprecated Use the
 * {@link https://deno.land/api?s=Deno.Permissions | Deno Permissions API}
 * directly instead. This module will be removed once the Standard Library
 * migrates to {@link https://jsr.io/ | JSR}.
 *
 * @module
 */ const { PermissionDenied } = Deno.errors;
function getPermissionString(descriptors) {
  return descriptors.length ? `  ${descriptors.map((pd)=>{
    switch(pd.name){
      case "read":
      case "write":
        return pd.path ? `--allow-${pd.name}=${pd.path}` : `--allow-${pd.name}`;
      case "net":
        return pd.host ? `--allow-${pd.name}=${pd.host}` : `--allow-${pd.name}`;
      default:
        return `--allow-${pd.name}`;
    }
  }).join("\n  ")}` : "";
}
export async function grant(descriptor, ...descriptors) {
  const result = [];
  descriptors = Array.isArray(descriptor) ? descriptor : [
    descriptor,
    ...descriptors
  ];
  for (const descriptor of descriptors){
    let state = (await Deno.permissions.query(descriptor)).state;
    if (state === "prompt") {
      state = (await Deno.permissions.request(descriptor)).state;
    }
    if (state === "granted") {
      result.push(descriptor);
    }
  }
  return result.length ? result : undefined;
}
export async function grantOrThrow(descriptor, ...descriptors) {
  const denied = [];
  descriptors = Array.isArray(descriptor) ? descriptor : [
    descriptor,
    ...descriptors
  ];
  for (const descriptor of descriptors){
    const { state } = await Deno.permissions.request(descriptor);
    if (state !== "granted") {
      denied.push(descriptor);
    }
  }
  if (denied.length) {
    throw new PermissionDenied(`The following permissions have not been granted:\n${getPermissionString(denied)}`);
  }
}
//# sourceMappingURL=data:application/json;base64,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
// denoCacheMetadata=14876962242630182588,14237289837222086385