// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
import { toReadableStream } from "jsr:/@std/io@^0.224.1/to-readable-stream";
/**
 * Create a {@linkcode ReadableStream} of {@linkcode Uint8Array}s from a
 * {@linkcode https://jsr.io/@std/io/doc/types/~/Reader | Reader}.
 *
 * When the pull algorithm is called on the stream, a chunk from the reader
 * will be read.  When `null` is returned from the reader, the stream will be
 * closed along with the reader (if it is also a {@linkcode https://jsr.io/@std/io/doc/types/~/Closer | Closer}).
 *
 * @param reader A reader to convert into a `ReadableStream`.
 * @param options Options for the `readableStreamFromReader` function.
 * @returns A `ReadableStream` of `Uint8Array`s.
 *
 * @example Convert a `Deno.FsFile` into a readable stream:
 * ```ts no-eval no-assert
 * import { readableStreamFromReader } from "@std/streams/readable-stream-from-reader";
 *
 * using file = await Deno.open("./README.md", { read: true });
 * const fileStream = readableStreamFromReader(file);
 * ```
 *
 * @deprecated This will be removed in 1.0.0. Use {@linkcode https://jsr.io/@std/io/doc/~/toReadableStream | toReadableStream} instead.
 */ export function readableStreamFromReader(reader, options = {}) {
  return toReadableStream(reader, options);
}
//# sourceMappingURL=data:application/json;base64,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
// denoCacheMetadata=10065344209348372715,9209215935946115885