import { z } from "zod";

import {
  ZodNavigationItem,
  ZodNavigationItemObject,
  ZodSidebarContents,
} from "./handwritten-schema-types.ts";
export {
  ZodNavigationItem,
  ZodNavigationItemObject,
  ZodSidebarContents,
} from "./handwritten-schema-types.ts";

// This file is automatically generated by `quarto dev-call build-artifacts`! Do not edit.",
//
// If you find yourself trying to rebuild types and `quarto dev-call build-artifacts` won't run because
// of bad type definitions, run the following:
// $ cd $QUARTO_ROOT
// $ ./package/dist/bin/tools/deno run --importmap=./src/import_map.json --allow-all ./package/src/common/create-schema-types.ts ./src/resources

export type MaybeArrayOf<T> = T | T[];
export type JsonObject = { [key: string]: unknown };
// export type SchemaObject = { [key: string]: string };

export const ZodDate = z.union([
  z.string(),
  z.object({ value: z.string(), format: z.string() }).passthrough().partial()
    .required({ value: true }),
]);

export const ZodDateFormat = z.string();

export const ZodMathMethods = z.enum(
  ["plain", "webtex", "gladtex", "mathml", "mathjax", "katex"] as const,
);

export const ZodPandocFormatRequestHeaders = z.array(z.array(z.string()));

export const ZodPandocFormatOutputFile = z.union([z.string(), z.literal(null)]);

export const ZodPandocFormatFilters = z.array(
  z.union([
    z.string(),
    z.object({ type: z.string(), path: z.string() }).passthrough().partial()
      .required({ path: true }),
    z.object({
      type: z.string(),
      path: z.string(),
      at: z.enum(
        [
          "pre-ast",
          "post-ast",
          "pre-quarto",
          "post-quarto",
          "pre-render",
          "post-render",
        ] as const,
      ),
    }).passthrough().partial().required({ path: true, at: true }),
    z.object({ type: z.enum(["citeproc"] as const) }).strict(),
  ]),
);

export const ZodPandocShortcodes = z.array(z.string());

export const ZodPageColumn = z.enum(
  [
    "body",
    "body-outset",
    "body-outset-left",
    "body-outset-right",
    "page",
    "page-left",
    "page-right",
    "page-inset",
    "page-inset-left",
    "page-inset-right",
    "screen",
    "screen-left",
    "screen-right",
    "screen-inset",
    "screen-inset-shaded",
    "screen-inset-left",
    "screen-inset-right",
    "margin",
  ] as const,
);

export const ZodContentsAuto = z.object({
  auto: z.union([z.boolean(), z.union([z.string(), z.array(z.string())])]),
}).passthrough().partial();

/* export const ZodNavigationItem = z.union([z.string(), z.lazy(() => ZodNavigationItemObject)]); */

/* export const ZodNavigationItemObject = z.object({"aria-label": z.string(), file: z.string(), href: z.string(), icon: z.string(), id: z.string(), menu: z.array(z.lazy(() => ZodNavigationItem)), text: z.string(), url: z.string(), rel: z.string(), target: z.string()}).strict().partial(); */

export const ZodGiscusThemes = z.enum(
  [
    "light",
    "light_high_contrast",
    "light_protanopia",
    "light_tritanopia",
    "dark",
    "dark_high_contrast",
    "dark_protanopia",
    "dark_tritanopia",
    "dark_dimmed",
    "transparent_dark",
    "cobalt",
    "purple_dark",
    "noborder_light",
    "noborder_dark",
    "noborder_gray",
    "preferred_color_scheme",
  ] as const,
);

export const ZodGiscusConfiguration = z.object({
  repo: z.string(),
  "repo-id": z.string(),
  category: z.string(),
  "category-id": z.string(),
  mapping: z.union([z.string(), z.number()]),
  "reactions-enabled": z.boolean(),
  loading: z.enum(["lazy"] as const),
  "input-position": z.enum(["top", "bottom"] as const),
  theme: z.union([
    z.string(),
    z.lazy(() => ZodGiscusThemes),
    z.object({
      light: z.union([z.string(), z.lazy(() => ZodGiscusThemes)]),
      dark: z.union([z.string(), z.lazy(() => ZodGiscusThemes)]),
    }).strict().partial(),
  ]),
  language: z.string(),
}).strict().partial().required({ repo: true });

export const ZodExternalEngine = z.object({ path: z.string() }).strict()
  .partial().required({ path: true });

export const ZodDocumentCommentsConfiguration = z.union([
  z.literal(false),
  z.object({
    utterances: z.object({
      repo: z.string(),
      label: z.string(),
      theme: z.string(),
      "issue-term": z.string(),
    }).strict().partial().required({ repo: true }),
    giscus: z.lazy(() => ZodGiscusConfiguration),
    hypothesis: z.union([
      z.boolean(),
      z.object({
        "client-url": z.string(),
        openSidebar: z.boolean(),
        showHighlights: z.union([
          z.boolean(),
          z.enum(["always", "whenSidebarOpen", "never"] as const),
        ]),
        theme: z.enum(["classic", "clean"] as const),
        enableExperimentalNewNoteButton: z.boolean(),
        usernameUrl: z.string(),
        services: z.array(
          z.object({
            apiUrl: z.string(),
            authority: z.string(),
            grantToken: z.string(),
            allowLeavingGroups: z.boolean(),
            enableShareLinks: z.boolean(),
            groups: z.union([
              z.enum(["$rpc:requestGroups"] as const),
              z.array(z.string()),
            ]),
            icon: z.string(),
          }).passthrough().partial().required({
            apiUrl: true,
            authority: true,
            grantToken: true,
          }),
        ),
        branding: z.object({
          accentColor: z.string(),
          appBackgroundColor: z.string(),
          ctaBackgroundColor: z.string(),
          selectionFontFamily: z.string(),
          annotationFontFamily: z.string(),
        }).passthrough().partial(),
        externalContainerSelector: z.string(),
        focus: z.object({
          user: z.object({
            username: z.string(),
            userid: z.string(),
            displayName: z.string(),
          }).passthrough().partial(),
        }).passthrough().partial().required({ user: true }),
        requestConfigFromFrame: z.object({
          origin: z.string(),
          ancestorLevel: z.number(),
        }).passthrough().partial(),
        assetRoot: z.string(),
        sidebarAppUrl: z.string(),
      }).strict().partial(),
    ]),
  }).strict().partial(),
]);

export const ZodSocialMetadata = z.object({
  title: z.string(),
  description: z.string(),
  image: z.string(),
  "image-alt": z.string(),
  "image-width": z.number(),
  "image-height": z.number(),
}).strict().partial();

export const ZodPageFooterRegion = z.union([
  z.string(),
  z.array(z.lazy(() => ZodNavigationItem)),
]);

/* export const ZodSidebarContents = z.union([z.string(), z.lazy(() => ZodContentsAuto), z.array(z.union([z.lazy(() => ZodNavigationItem), z.string(), z.object({section: z.union([z.string(), z.null()]), contents: z.lazy(() => ZodSidebarContents)}).strict().partial(), z.lazy(() => ZodContentsAuto)]))]); */

export const ZodProjectPreview = z.object({
  port: z.number(),
  host: z.string(),
  serve: z.lazy(() => ZodProjectServe),
  browser: z.boolean(),
  "watch-inputs": z.boolean(),
  navigate: z.boolean(),
  timeout: z.number(),
}).strict().partial();

export const ZodProjectServe = z.object({
  cmd: z.string(),
  args: z.string(),
  env: z.object({}).passthrough().partial(),
  ready: z.string(),
}).strict().partial().required({ cmd: true, ready: true });

export const ZodPublish = z.object({
  netlify: z.array(z.lazy(() => ZodPublishRecord)),
}).strict().partial();

export const ZodPublishRecord = z.object({ id: z.string(), url: z.string() })
  .strict().partial();

export const ZodTwitterCardConfig = z.object({
  title: z.string(),
  description: z.string(),
  image: z.string(),
  "image-alt": z.string(),
  "image-width": z.number(),
  "image-height": z.number(),
  "card-style": z.enum(["summary", "summary_large_image"] as const),
  creator: z.string(),
  site: z.string(),
}).strict().partial();

export const ZodOpenGraphConfig = z.object({
  title: z.string(),
  description: z.string(),
  image: z.string(),
  "image-alt": z.string(),
  "image-width": z.number(),
  "image-height": z.number(),
  locale: z.string(),
  "site-name": z.string(),
}).strict().partial();

export const ZodPageFooter = z.object({
  left: z.lazy(() => ZodPageFooterRegion),
  right: z.lazy(() => ZodPageFooterRegion),
  center: z.lazy(() => ZodPageFooterRegion),
  border: z.union([z.boolean(), z.string()]),
  background: z.string(),
  foreground: z.string(),
}).strict().partial();

export const ZodBaseWebsite = z.object({
  title: z.string(),
  description: z.string(),
  favicon: z.string(),
  "site-url": z.string(),
  "site-path": z.string(),
  "repo-url": z.string(),
  "repo-link-target": z.string(),
  "repo-link-rel": z.string(),
  "repo-subdir": z.string(),
  "repo-branch": z.string(),
  "issue-url": z.string(),
  "repo-actions": z.union([
    z.enum(["none", "edit", "source", "issue"] as const),
    z.array(z.enum(["none", "edit", "source", "issue"] as const)),
  ]),
  "reader-mode": z.boolean(),
  "google-analytics": z.union([
    z.string(),
    z.object({
      "tracking-id": z.string(),
      storage: z.enum(["cookies", "none"] as const),
      "anonymize-ip": z.boolean(),
      version: z.union([z.literal(3), z.literal(4)]),
    }).passthrough().partial(),
  ]),
  "plausible-analytics": z.union([
    z.string(),
    z.object({ path: z.string() }).strict().partial().required({ path: true }),
  ]),
  announcement: z.union([
    z.string(),
    z.object({
      content: z.string(),
      dismissable: z.boolean(),
      icon: z.string(),
      position: z.enum(["above-navbar", "below-navbar"] as const),
      type: z.enum(
        [
          "primary",
          "secondary",
          "success",
          "danger",
          "warning",
          "info",
          "light",
          "dark",
        ] as const,
      ),
    }).passthrough().partial(),
  ]),
  "cookie-consent": z.union([
    z.enum(["express", "implied"] as const),
    z.boolean(),
    z.object({
      type: z.enum(["express", "implied"] as const),
      style: z.enum(
        ["simple", "headline", "interstitial", "standalone"] as const,
      ),
      palette: z.enum(["light", "dark"] as const),
      "policy-url": z.string(),
      language: z.string(),
      "prefs-text": z.string(),
    }).passthrough().partial(),
  ]),
  search: z.union([
    z.boolean(),
    z.object({
      location: z.enum(["navbar", "sidebar"] as const),
      type: z.enum(["overlay", "textbox"] as const),
      limit: z.number(),
      "collapse-after": z.number(),
      "copy-button": z.boolean(),
      "merge-navbar-crumbs": z.boolean(),
      "keyboard-shortcut": z.union([z.string(), z.array(z.string())]),
      "show-item-context": z.union([
        z.enum(["tree", "parent", "root"] as const),
        z.boolean(),
      ]),
      algolia: z.object({
        "index-name": z.string(),
        "application-id": z.string(),
        "search-only-api-key": z.string(),
        "analytics-events": z.boolean(),
        "show-logo": z.boolean(),
        "index-fields": z.object({
          href: z.string(),
          title: z.string(),
          text: z.string(),
          section: z.string(),
        }).strict().partial(),
        params: z.object({}).passthrough().partial(),
      }).strict().partial(),
    }).strict().partial(),
  ]),
  navbar: z.union([
    z.boolean(),
    z.object({
      title: z.union([z.string(), z.boolean()]),
      logo: z.lazy(() => ZodLogoLightDarkSpecifier),
      "logo-alt": z.string(),
      "logo-href": z.string(),
      background: z.string(),
      foreground: z.string(),
      search: z.boolean(),
      pinned: z.boolean(),
      collapse: z.boolean(),
      "collapse-below": z.enum(["sm", "md", "lg", "xl", "xxl"] as const),
      left: z.array(z.lazy(() => ZodNavigationItem)),
      right: z.array(z.lazy(() => ZodNavigationItem)),
      "toggle-position": z.enum(["left", "right"] as const),
      "tools-collapse": z.boolean(),
    }).passthrough().partial(),
  ]),
  sidebar: z.union([
    z.boolean(),
    z.union([
      z.object({
        id: z.string(),
        title: z.union([z.string(), z.boolean()]),
        logo: z.lazy(() => ZodLogoLightDarkSpecifier),
        "logo-alt": z.string(),
        "logo-href": z.string(),
        search: z.boolean(),
        tools: z.array(z.lazy(() => ZodNavigationItemObject)),
        contents: z.lazy(() => ZodSidebarContents),
        style: z.enum(["docked", "floating"] as const),
        background: z.string(),
        foreground: z.string(),
        border: z.boolean(),
        alignment: z.enum(["left", "right", "center"] as const),
        "collapse-level": z.number(),
        pinned: z.boolean(),
        header: z.union([z.string(), z.array(z.string())]),
        footer: z.union([z.string(), z.array(z.string())]),
      }).passthrough().partial(),
      z.array(
        z.object({
          id: z.string(),
          title: z.union([z.string(), z.boolean()]),
          logo: z.lazy(() => ZodLogoLightDarkSpecifier),
          "logo-alt": z.string(),
          "logo-href": z.string(),
          search: z.boolean(),
          tools: z.array(z.lazy(() => ZodNavigationItemObject)),
          contents: z.lazy(() => ZodSidebarContents),
          style: z.enum(["docked", "floating"] as const),
          background: z.string(),
          foreground: z.string(),
          border: z.boolean(),
          alignment: z.enum(["left", "right", "center"] as const),
          "collapse-level": z.number(),
          pinned: z.boolean(),
          header: z.union([z.string(), z.array(z.string())]),
          footer: z.union([z.string(), z.array(z.string())]),
        }).passthrough().partial(),
      ),
    ]),
  ]),
  "body-header": z.string(),
  "body-footer": z.string(),
  "margin-header": z.union([z.string(), z.array(z.string())]),
  "margin-footer": z.union([z.string(), z.array(z.string())]),
  "page-navigation": z.boolean(),
  "back-to-top-navigation": z.boolean(),
  "bread-crumbs": z.boolean(),
  "page-footer": z.union([z.string(), z.lazy(() => ZodPageFooter)]),
  image: z.string(),
  "image-alt": z.string(),
  comments: z.lazy(() => ZodDocumentCommentsConfiguration),
  "open-graph": z.union([z.boolean(), z.lazy(() => ZodOpenGraphConfig)]),
  "twitter-card": z.union([z.boolean(), z.lazy(() => ZodTwitterCardConfig)]),
  "other-links": z.lazy(() => ZodOtherLinks),
  "code-links": z.union([z.boolean(), z.lazy(() => ZodCodeLinksSchema)]),
  drafts: z.union([z.string(), z.array(z.string())]),
  "draft-mode": z.enum(["visible", "unlinked", "gone"] as const),
}).strict().partial();

export const ZodBookSchema = z.object({
  title: z.string(),
  description: z.string(),
  favicon: z.string(),
  "site-url": z.string(),
  "site-path": z.string(),
  "repo-url": z.string(),
  "repo-link-target": z.string(),
  "repo-link-rel": z.string(),
  "repo-subdir": z.string(),
  "repo-branch": z.string(),
  "issue-url": z.string(),
  "repo-actions": z.union([
    z.enum(["none", "edit", "source", "issue"] as const),
    z.array(z.enum(["none", "edit", "source", "issue"] as const)),
  ]),
  "reader-mode": z.boolean(),
  "google-analytics": z.union([
    z.string(),
    z.object({
      "tracking-id": z.string(),
      storage: z.enum(["cookies", "none"] as const),
      "anonymize-ip": z.boolean(),
      version: z.union([z.literal(3), z.literal(4)]),
    }).passthrough().partial(),
  ]),
  "plausible-analytics": z.union([
    z.string(),
    z.object({ path: z.string() }).strict().partial().required({ path: true }),
  ]),
  announcement: z.union([
    z.string(),
    z.object({
      content: z.string(),
      dismissable: z.boolean(),
      icon: z.string(),
      position: z.enum(["above-navbar", "below-navbar"] as const),
      type: z.enum(
        [
          "primary",
          "secondary",
          "success",
          "danger",
          "warning",
          "info",
          "light",
          "dark",
        ] as const,
      ),
    }).passthrough().partial(),
  ]),
  "cookie-consent": z.union([
    z.enum(["express", "implied"] as const),
    z.boolean(),
    z.object({
      type: z.enum(["express", "implied"] as const),
      style: z.enum(
        ["simple", "headline", "interstitial", "standalone"] as const,
      ),
      palette: z.enum(["light", "dark"] as const),
      "policy-url": z.string(),
      language: z.string(),
      "prefs-text": z.string(),
    }).passthrough().partial(),
  ]),
  search: z.union([
    z.boolean(),
    z.object({
      location: z.enum(["navbar", "sidebar"] as const),
      type: z.enum(["overlay", "textbox"] as const),
      limit: z.number(),
      "collapse-after": z.number(),
      "copy-button": z.boolean(),
      "merge-navbar-crumbs": z.boolean(),
      "keyboard-shortcut": z.union([z.string(), z.array(z.string())]),
      "show-item-context": z.union([
        z.enum(["tree", "parent", "root"] as const),
        z.boolean(),
      ]),
      algolia: z.object({
        "index-name": z.string(),
        "application-id": z.string(),
        "search-only-api-key": z.string(),
        "analytics-events": z.boolean(),
        "show-logo": z.boolean(),
        "index-fields": z.object({
          href: z.string(),
          title: z.string(),
          text: z.string(),
          section: z.string(),
        }).strict().partial(),
        params: z.object({}).passthrough().partial(),
      }).strict().partial(),
    }).strict().partial(),
  ]),
  navbar: z.union([
    z.boolean(),
    z.object({
      title: z.union([z.string(), z.boolean()]),
      logo: z.lazy(() => ZodLogoLightDarkSpecifier),
      "logo-alt": z.string(),
      "logo-href": z.string(),
      background: z.string(),
      foreground: z.string(),
      search: z.boolean(),
      pinned: z.boolean(),
      collapse: z.boolean(),
      "collapse-below": z.enum(["sm", "md", "lg", "xl", "xxl"] as const),
      left: z.array(z.lazy(() => ZodNavigationItem)),
      right: z.array(z.lazy(() => ZodNavigationItem)),
      "toggle-position": z.enum(["left", "right"] as const),
      "tools-collapse": z.boolean(),
    }).passthrough().partial(),
  ]),
  sidebar: z.union([
    z.boolean(),
    z.union([
      z.object({
        id: z.string(),
        title: z.union([z.string(), z.boolean()]),
        logo: z.lazy(() => ZodLogoLightDarkSpecifier),
        "logo-alt": z.string(),
        "logo-href": z.string(),
        search: z.boolean(),
        tools: z.array(z.lazy(() => ZodNavigationItemObject)),
        contents: z.lazy(() => ZodSidebarContents),
        style: z.enum(["docked", "floating"] as const),
        background: z.string(),
        foreground: z.string(),
        border: z.boolean(),
        alignment: z.enum(["left", "right", "center"] as const),
        "collapse-level": z.number(),
        pinned: z.boolean(),
        header: z.union([z.string(), z.array(z.string())]),
        footer: z.union([z.string(), z.array(z.string())]),
      }).passthrough().partial(),
      z.array(
        z.object({
          id: z.string(),
          title: z.union([z.string(), z.boolean()]),
          logo: z.lazy(() => ZodLogoLightDarkSpecifier),
          "logo-alt": z.string(),
          "logo-href": z.string(),
          search: z.boolean(),
          tools: z.array(z.lazy(() => ZodNavigationItemObject)),
          contents: z.lazy(() => ZodSidebarContents),
          style: z.enum(["docked", "floating"] as const),
          background: z.string(),
          foreground: z.string(),
          border: z.boolean(),
          alignment: z.enum(["left", "right", "center"] as const),
          "collapse-level": z.number(),
          pinned: z.boolean(),
          header: z.union([z.string(), z.array(z.string())]),
          footer: z.union([z.string(), z.array(z.string())]),
        }).passthrough().partial(),
      ),
    ]),
  ]),
  "body-header": z.string(),
  "body-footer": z.string(),
  "margin-header": z.union([z.string(), z.array(z.string())]),
  "margin-footer": z.union([z.string(), z.array(z.string())]),
  "page-navigation": z.boolean(),
  "back-to-top-navigation": z.boolean(),
  "bread-crumbs": z.boolean(),
  "page-footer": z.union([z.string(), z.lazy(() => ZodPageFooter)]),
  image: z.string(),
  "image-alt": z.string(),
  comments: z.lazy(() => ZodDocumentCommentsConfiguration),
  "open-graph": z.union([z.boolean(), z.lazy(() => ZodOpenGraphConfig)]),
  "twitter-card": z.union([z.boolean(), z.lazy(() => ZodTwitterCardConfig)]),
  "other-links": z.lazy(() => ZodOtherLinks),
  "code-links": z.union([z.boolean(), z.lazy(() => ZodCodeLinksSchema)]),
  drafts: z.union([z.string(), z.array(z.string())]),
  "draft-mode": z.enum(["visible", "unlinked", "gone"] as const),
  subtitle: z.string(),
  author: z.union([
    z.union([z.string(), z.object({}).passthrough()]),
    z.array(z.union([z.string(), z.object({}).passthrough()])),
  ]),
  date: z.string(),
  "date-format": z.string(),
  abstract: z.string(),
  chapters: z.lazy(() => ZodChapterList),
  appendices: z.lazy(() => ZodChapterList),
  references: z.string(),
  "output-file": z.string(),
  "cover-image": z.string(),
  "cover-image-alt": z.string(),
  sharing: z.union([
    z.enum(["twitter", "facebook", "linkedin"] as const),
    z.array(z.enum(["twitter", "facebook", "linkedin"] as const)),
  ]),
  downloads: z.union([
    z.enum(["pdf", "epub", "docx"] as const),
    z.array(z.enum(["pdf", "epub", "docx"] as const)),
  ]),
  tools: z.array(z.lazy(() => ZodNavigationItem)),
  doi: z.string(),
}).strict().partial();

export const ZodChapterItem = z.union([
  z.lazy(() => ZodNavigationItem),
  z.object({
    part: z.string(),
    chapters: z.array(z.lazy(() => ZodNavigationItem)),
  }).passthrough().partial().required({ part: true }),
]);

export const ZodChapterList = z.array(z.lazy(() => ZodChapterItem));

export const ZodOtherLinks = z.array(
  z.object({
    text: z.string(),
    href: z.string(),
    icon: z.string(),
    rel: z.string(),
    target: z.string(),
  }).passthrough().partial().required({ text: true, href: true }),
);

export const ZodCrossrefLabelsSchema = z.string();

export const ZodEpubContributor = z.union([
  z.string(),
  z.union([
    z.object({ role: z.string(), "file-as": z.string(), text: z.string() })
      .strict().partial(),
    z.array(
      z.object({ role: z.string(), "file-as": z.string(), text: z.string() })
        .strict().partial(),
    ),
  ]),
]);

export const ZodFormatLanguage = z.object({
  "toc-title-document": z.string(),
  "toc-title-website": z.string(),
  "related-formats-title": z.string(),
  "related-notebooks-title": z.string(),
  "callout-tip-title": z.string(),
  "callout-note-title": z.string(),
  "callout-warning-title": z.string(),
  "callout-important-title": z.string(),
  "callout-caution-title": z.string(),
  "section-title-abstract": z.string(),
  "section-title-footnotes": z.string(),
  "section-title-appendices": z.string(),
  "code-summary": z.string(),
  "code-tools-menu-caption": z.string(),
  "code-tools-show-all-code": z.string(),
  "code-tools-hide-all-code": z.string(),
  "code-tools-view-source": z.string(),
  "code-tools-source-code": z.string(),
  "search-no-results-text": z.string(),
  "copy-button-tooltip": z.string(),
  "copy-button-tooltip-success": z.string(),
  "repo-action-links-edit": z.string(),
  "repo-action-links-source": z.string(),
  "repo-action-links-issue": z.string(),
  "search-matching-documents-text": z.string(),
  "search-copy-link-title": z.string(),
  "search-hide-matches-text": z.string(),
  "search-more-match-text": z.string(),
  "search-more-matches-text": z.string(),
  "search-clear-button-title": z.string(),
  "search-text-placeholder": z.string(),
  "search-detached-cancel-button-title": z.string(),
  "search-submit-button-title": z.string(),
  "crossref-fig-title": z.string(),
  "crossref-tbl-title": z.string(),
  "crossref-lst-title": z.string(),
  "crossref-thm-title": z.string(),
  "crossref-lem-title": z.string(),
  "crossref-cor-title": z.string(),
  "crossref-prp-title": z.string(),
  "crossref-cnj-title": z.string(),
  "crossref-def-title": z.string(),
  "crossref-exm-title": z.string(),
  "crossref-exr-title": z.string(),
  "crossref-fig-prefix": z.string(),
  "crossref-tbl-prefix": z.string(),
  "crossref-lst-prefix": z.string(),
  "crossref-ch-prefix": z.string(),
  "crossref-apx-prefix": z.string(),
  "crossref-sec-prefix": z.string(),
  "crossref-eq-prefix": z.string(),
  "crossref-thm-prefix": z.string(),
  "crossref-lem-prefix": z.string(),
  "crossref-cor-prefix": z.string(),
  "crossref-prp-prefix": z.string(),
  "crossref-cnj-prefix": z.string(),
  "crossref-def-prefix": z.string(),
  "crossref-exm-prefix": z.string(),
  "crossref-exr-prefix": z.string(),
  "crossref-lof-title": z.string(),
  "crossref-lot-title": z.string(),
  "crossref-lol-title": z.string(),
}).passthrough().partial();

export const ZodWebsiteAbout = z.object({
  id: z.string(),
  template: z.union([
    z.enum(["jolla", "trestles", "solana", "marquee", "broadside"] as const),
    z.string(),
  ]),
  image: z.string(),
  "image-alt": z.string(),
  "image-title": z.string(),
  "image-width": z.string(),
  "image-shape": z.enum(["rectangle", "round", "rounded"] as const),
  links: z.array(z.lazy(() => ZodNavigationItem)),
}).strict().partial().required({ template: true });

export const ZodWebsiteListing = z.object({
  id: z.string(),
  type: z.enum(["default", "table", "grid", "custom"] as const),
  contents: z.union([
    z.union([z.string(), z.lazy(() => ZodWebsiteListingContentsObject)]),
    z.array(
      z.union([z.string(), z.lazy(() => ZodWebsiteListingContentsObject)]),
    ),
  ]),
  sort: z.union([z.boolean(), z.union([z.string(), z.array(z.string())])]),
  "max-items": z.number(),
  "page-size": z.number(),
  "sort-ui": z.union([z.boolean(), z.array(z.string())]),
  "filter-ui": z.union([z.boolean(), z.array(z.string())]),
  categories: z.union([
    z.boolean(),
    z.enum(["numbered", "unnumbered", "cloud"] as const),
  ]),
  feed: z.union([
    z.boolean(),
    z.object({
      items: z.number(),
      type: z.enum(["full", "partial", "metadata"] as const),
      title: z.string(),
      image: z.string(),
      description: z.string(),
      language: z.string(),
      categories: z.union([z.string(), z.array(z.string())]),
      "xml-stylesheet": z.string(),
    }).strict().partial(),
  ]),
  "date-format": z.string(),
  "max-description-length": z.number(),
  "image-placeholder": z.string(),
  "image-lazy-loading": z.boolean(),
  "image-align": z.enum(["left", "right"] as const),
  "image-height": z.string(),
  "grid-columns": z.number(),
  "grid-item-border": z.boolean(),
  "grid-item-align": z.enum(["left", "right", "center"] as const),
  "table-striped": z.boolean(),
  "table-hover": z.boolean(),
  template: z.string(),
  "template-params": z.object({}).passthrough(),
  fields: z.array(z.string()),
  "field-display-names": z.object({}).passthrough().partial(),
  "field-types": z.object({}).passthrough().partial(),
  "field-links": z.array(z.string()),
  "field-required": z.array(z.string()),
  include: z.union([
    z.object({}).passthrough(),
    z.array(z.object({}).passthrough()),
  ]),
  exclude: z.union([
    z.object({}).passthrough(),
    z.array(z.object({}).passthrough()),
  ]),
}).strict().partial();

export const ZodWebsiteListingContentsObject = z.object({
  author: z.union([z.string(), z.array(z.string())]),
  date: z.string(),
  title: z.string(),
  subtitle: z.string(),
}).passthrough().partial();

export const ZodCslDate = z.union([
  z.string(),
  z.union([z.number(), z.array(z.number())]),
  z.object({ year: z.number(), month: z.number(), day: z.number() })
    .passthrough().partial(),
]);

export const ZodCslPerson = z.union([
  z.union([z.string(), z.array(z.string())]),
  z.union([
    z.object({ "family-name": z.string(), "given-name": z.string() })
      .passthrough().partial(),
    z.array(
      z.object({ "family-name": z.string(), "given-name": z.string() })
        .passthrough().partial(),
    ),
  ]),
]);

export const ZodCslNumber = z.union([z.number(), z.string()]);

export const ZodCslItemShared = z.object({
  "abstract-url": z.string(),
  accessed: z.lazy(() => ZodCslDate),
  annote: z.string(),
  archive: z.string(),
  "archive-collection": z.string(),
  archive_collection: z.string(),
  "archive-location": z.string(),
  archive_location: z.string(),
  "archive-place": z.string(),
  authority: z.string(),
  "available-date": z.lazy(() => ZodCslDate),
  "call-number": z.string(),
  chair: z.lazy(() => ZodCslPerson),
  "chapter-number": z.lazy(() => ZodCslNumber),
  "citation-key": z.string(),
  "citation-label": z.string(),
  "citation-number": z.lazy(() => ZodCslNumber),
  "collection-editor": z.lazy(() => ZodCslPerson),
  "collection-number": z.lazy(() => ZodCslNumber),
  "collection-title": z.string(),
  compiler: z.lazy(() => ZodCslPerson),
  composer: z.lazy(() => ZodCslPerson),
  "container-author": z.lazy(() => ZodCslPerson),
  "container-title": z.string(),
  "container-title-short": z.string(),
  contributor: z.lazy(() => ZodCslPerson),
  curator: z.lazy(() => ZodCslPerson),
  dimensions: z.string(),
  director: z.lazy(() => ZodCslPerson),
  division: z.string(),
  DOI: z.string(),
  edition: z.lazy(() => ZodCslNumber),
  editor: z.lazy(() => ZodCslPerson),
  "editorial-director": z.lazy(() => ZodCslPerson),
  "editor-translator": z.lazy(() => ZodCslPerson),
  event: z.string(),
  "event-date": z.lazy(() => ZodCslDate),
  "event-title": z.string(),
  "event-place": z.string(),
  "executive-producer": z.lazy(() => ZodCslPerson),
  "first-reference-note-number": z.lazy(() => ZodCslNumber),
  "fulltext-url": z.string(),
  genre: z.string(),
  guest: z.lazy(() => ZodCslPerson),
  host: z.lazy(() => ZodCslPerson),
  id: z.union([z.string(), z.number()]),
  illustrator: z.lazy(() => ZodCslPerson),
  interviewer: z.lazy(() => ZodCslPerson),
  isbn: z.string(),
  ISBN: z.string(),
  issn: z.string(),
  ISSN: z.string(),
  issue: z.lazy(() => ZodCslNumber),
  issued: z.lazy(() => ZodCslDate),
  jurisdiction: z.string(),
  keyword: z.string(),
  language: z.string(),
  license: z.string(),
  locator: z.lazy(() => ZodCslNumber),
  medium: z.string(),
  narrator: z.lazy(() => ZodCslPerson),
  note: z.string(),
  number: z.lazy(() => ZodCslNumber),
  "number-of-pages": z.lazy(() => ZodCslNumber),
  "number-of-volumes": z.lazy(() => ZodCslNumber),
  organizer: z.lazy(() => ZodCslPerson),
  "original-author": z.lazy(() => ZodCslPerson),
  "original-date": z.lazy(() => ZodCslDate),
  "original-publisher": z.string(),
  "original-publisher-place": z.string(),
  "original-title": z.string(),
  page: z.lazy(() => ZodCslNumber),
  "page-first": z.lazy(() => ZodCslNumber),
  "page-last": z.lazy(() => ZodCslNumber),
  "part-number": z.lazy(() => ZodCslNumber),
  "part-title": z.string(),
  "pdf-url": z.string(),
  performer: z.lazy(() => ZodCslPerson),
  pmcid: z.string(),
  PMCID: z.string(),
  pmid: z.string(),
  PMID: z.string(),
  "printing-number": z.lazy(() => ZodCslNumber),
  producer: z.lazy(() => ZodCslPerson),
  "public-url": z.string(),
  publisher: z.string(),
  "publisher-place": z.string(),
  recipient: z.lazy(() => ZodCslPerson),
  "reviewed-author": z.lazy(() => ZodCslPerson),
  "reviewed-genre": z.string(),
  "reviewed-title": z.string(),
  scale: z.string(),
  "script-writer": z.lazy(() => ZodCslPerson),
  section: z.lazy(() => ZodCslNumber),
  "series-creator": z.lazy(() => ZodCslPerson),
  source: z.string(),
  status: z.string(),
  submitted: z.lazy(() => ZodCslDate),
  "supplement-number": z.lazy(() => ZodCslNumber),
  "title-short": z.string(),
  translator: z.lazy(() => ZodCslPerson),
  type: z.enum(
    [
      "article",
      "article-journal",
      "article-magazine",
      "article-newspaper",
      "bill",
      "book",
      "broadcast",
      "chapter",
      "classic",
      "collection",
      "dataset",
      "document",
      "entry",
      "entry-dictionary",
      "entry-encyclopedia",
      "event",
      "figure",
      "graphic",
      "hearing",
      "interview",
      "legal_case",
      "legislation",
      "manuscript",
      "map",
      "motion_picture",
      "musical_score",
      "pamphlet",
      "paper-conference",
      "patent",
      "performance",
      "periodical",
      "personal_communication",
      "post",
      "post-weblog",
      "regulation",
      "report",
      "review",
      "review-book",
      "software",
      "song",
      "speech",
      "standard",
      "thesis",
      "treaty",
      "webpage",
    ] as const,
  ),
  url: z.string(),
  URL: z.string(),
  version: z.lazy(() => ZodCslNumber),
  volume: z.lazy(() => ZodCslNumber),
  "volume-title": z.string(),
  "year-suffix": z.string(),
}).passthrough().partial();

export const ZodCslItem = z.object({
  "abstract-url": z.string(),
  accessed: z.lazy(() => ZodCslDate),
  annote: z.string(),
  archive: z.string(),
  "archive-collection": z.string(),
  archive_collection: z.string(),
  "archive-location": z.string(),
  archive_location: z.string(),
  "archive-place": z.string(),
  authority: z.string(),
  "available-date": z.lazy(() => ZodCslDate),
  "call-number": z.string(),
  chair: z.lazy(() => ZodCslPerson),
  "chapter-number": z.lazy(() => ZodCslNumber),
  "citation-key": z.string(),
  "citation-label": z.string(),
  "citation-number": z.lazy(() => ZodCslNumber),
  "collection-editor": z.lazy(() => ZodCslPerson),
  "collection-number": z.lazy(() => ZodCslNumber),
  "collection-title": z.string(),
  compiler: z.lazy(() => ZodCslPerson),
  composer: z.lazy(() => ZodCslPerson),
  "container-author": z.lazy(() => ZodCslPerson),
  "container-title": z.string(),
  "container-title-short": z.string(),
  contributor: z.lazy(() => ZodCslPerson),
  curator: z.lazy(() => ZodCslPerson),
  dimensions: z.string(),
  director: z.lazy(() => ZodCslPerson),
  division: z.string(),
  DOI: z.string(),
  edition: z.lazy(() => ZodCslNumber),
  editor: z.lazy(() => ZodCslPerson),
  "editorial-director": z.lazy(() => ZodCslPerson),
  "editor-translator": z.lazy(() => ZodCslPerson),
  event: z.string(),
  "event-date": z.lazy(() => ZodCslDate),
  "event-title": z.string(),
  "event-place": z.string(),
  "executive-producer": z.lazy(() => ZodCslPerson),
  "first-reference-note-number": z.lazy(() => ZodCslNumber),
  "fulltext-url": z.string(),
  genre: z.string(),
  guest: z.lazy(() => ZodCslPerson),
  host: z.lazy(() => ZodCslPerson),
  id: z.union([z.string(), z.number()]),
  illustrator: z.lazy(() => ZodCslPerson),
  interviewer: z.lazy(() => ZodCslPerson),
  isbn: z.string(),
  ISBN: z.string(),
  issn: z.string(),
  ISSN: z.string(),
  issue: z.lazy(() => ZodCslNumber),
  issued: z.lazy(() => ZodCslDate),
  jurisdiction: z.string(),
  keyword: z.string(),
  language: z.string(),
  license: z.string(),
  locator: z.lazy(() => ZodCslNumber),
  medium: z.string(),
  narrator: z.lazy(() => ZodCslPerson),
  note: z.string(),
  number: z.lazy(() => ZodCslNumber),
  "number-of-pages": z.lazy(() => ZodCslNumber),
  "number-of-volumes": z.lazy(() => ZodCslNumber),
  organizer: z.lazy(() => ZodCslPerson),
  "original-author": z.lazy(() => ZodCslPerson),
  "original-date": z.lazy(() => ZodCslDate),
  "original-publisher": z.string(),
  "original-publisher-place": z.string(),
  "original-title": z.string(),
  page: z.lazy(() => ZodCslNumber),
  "page-first": z.lazy(() => ZodCslNumber),
  "page-last": z.lazy(() => ZodCslNumber),
  "part-number": z.lazy(() => ZodCslNumber),
  "part-title": z.string(),
  "pdf-url": z.string(),
  performer: z.lazy(() => ZodCslPerson),
  pmcid: z.string(),
  PMCID: z.string(),
  pmid: z.string(),
  PMID: z.string(),
  "printing-number": z.lazy(() => ZodCslNumber),
  producer: z.lazy(() => ZodCslPerson),
  "public-url": z.string(),
  publisher: z.string(),
  "publisher-place": z.string(),
  recipient: z.lazy(() => ZodCslPerson),
  "reviewed-author": z.lazy(() => ZodCslPerson),
  "reviewed-genre": z.string(),
  "reviewed-title": z.string(),
  scale: z.string(),
  "script-writer": z.lazy(() => ZodCslPerson),
  section: z.lazy(() => ZodCslNumber),
  "series-creator": z.lazy(() => ZodCslPerson),
  source: z.string(),
  status: z.string(),
  submitted: z.lazy(() => ZodCslDate),
  "supplement-number": z.lazy(() => ZodCslNumber),
  "title-short": z.string(),
  translator: z.lazy(() => ZodCslPerson),
  type: z.enum(
    [
      "article",
      "article-journal",
      "article-magazine",
      "article-newspaper",
      "bill",
      "book",
      "broadcast",
      "chapter",
      "classic",
      "collection",
      "dataset",
      "document",
      "entry",
      "entry-dictionary",
      "entry-encyclopedia",
      "event",
      "figure",
      "graphic",
      "hearing",
      "interview",
      "legal_case",
      "legislation",
      "manuscript",
      "map",
      "motion_picture",
      "musical_score",
      "pamphlet",
      "paper-conference",
      "patent",
      "performance",
      "periodical",
      "personal_communication",
      "post",
      "post-weblog",
      "regulation",
      "report",
      "review",
      "review-book",
      "software",
      "song",
      "speech",
      "standard",
      "thesis",
      "treaty",
      "webpage",
    ] as const,
  ),
  url: z.string(),
  URL: z.string(),
  version: z.lazy(() => ZodCslNumber),
  volume: z.lazy(() => ZodCslNumber),
  "volume-title": z.string(),
  "year-suffix": z.string(),
  abstract: z.string(),
  author: z.lazy(() => ZodCslPerson),
  doi: z.string(),
  references: z.string(),
  title: z.string(),
}).strict().partial();

export const ZodCitationItem = z.object({
  abstract: z.string(),
  author: z.lazy(() => ZodCslPerson),
  doi: z.string(),
  references: z.string(),
  title: z.string(),
  id: z.union([z.string(), z.number()]),
  "article-id": z.union([
    z.union([
      z.string(),
      z.object({ type: z.string(), value: z.string() }).passthrough().partial(),
    ]),
    z.array(
      z.union([
        z.string(),
        z.object({ type: z.string(), value: z.string() }).passthrough()
          .partial(),
      ]),
    ),
  ]),
  "elocation-id": z.string(),
  eissn: z.string(),
  pissn: z.string(),
  "art-access-id": z.string(),
  "publisher-location": z.string(),
  subject: z.string(),
  categories: z.union([z.string(), z.array(z.string())]),
  "container-id": z.union([
    z.union([
      z.string(),
      z.object({ type: z.string(), value: z.string() }).passthrough().partial(),
    ]),
    z.array(
      z.union([
        z.string(),
        z.object({ type: z.string(), value: z.string() }).passthrough()
          .partial(),
      ]),
    ),
  ]),
  "jats-type": z.string(),
}).strict().partial();

export const ZodSmartInclude = z.union([
  z.object({ text: z.string() }).strict(),
  z.object({ file: z.string() }).strict(),
]);

export const ZodSemver = z.string().regex(
  new RegExp(
    "^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$",
  ),
);

export const ZodQuartoDate = z.union([
  z.string(),
  z.object({ format: z.string(), value: z.string() }).strict().partial()
    .required({ value: true }),
]);

export const ZodProjectProfile = z.object({
  default: z.union([z.string(), z.array(z.string())]),
  group: z.union([z.array(z.string()), z.array(z.array(z.string()))]),
}).strict().partial();

export const ZodBadParseSchema = z.object({}).passthrough().partial();

export const ZodQuartoDevSchema = z.object({
  _quarto: z.object({
    "trace-filters": z.string(),
    tests: z.object({
      run: z.object({
        ci: z.boolean(),
        os: z.union([
          z.enum(["linux", "darwin", "windows"] as const),
          z.array(z.enum(["linux", "darwin", "windows"] as const)),
        ]),
        not_os: z.union([
          z.enum(["linux", "darwin", "windows"] as const),
          z.array(z.enum(["linux", "darwin", "windows"] as const)),
        ]),
      }).passthrough().partial(),
    }).passthrough().partial(),
  }).passthrough().partial(),
}).passthrough().partial();

export const ZodNotebookViewSchema = z.object({
  notebook: z.string(),
  title: z.union([z.string(), z.boolean()]),
  url: z.string(),
  "download-url": z.string(),
}).passthrough().partial().required({ notebook: true });

export const ZodCodeLinksSchema = z.union([
  z.boolean(),
  z.union([
    z.union([
      z.object({
        icon: z.string(),
        text: z.string(),
        href: z.string(),
        rel: z.string(),
        target: z.string(),
      }).passthrough().partial(),
      z.enum(["repo", "binder", "devcontainer"] as const),
    ]),
    z.array(
      z.union([
        z.object({
          icon: z.string(),
          text: z.string(),
          href: z.string(),
          rel: z.string(),
          target: z.string(),
        }).passthrough().partial(),
        z.enum(["repo", "binder", "devcontainer"] as const),
      ]),
    ),
  ]),
]);

export const ZodManuscriptSchema = z.object({
  article: z.string(),
  "code-links": z.lazy(() => ZodCodeLinksSchema),
  "manuscript-url": z.string(),
  "meca-bundle": z.union([z.boolean(), z.string()]),
  notebooks: z.array(
    z.union([z.string(), z.lazy(() => ZodNotebookViewSchema)]),
  ),
  resources: z.union([z.string(), z.array(z.string())]),
  environment: z.union([z.string(), z.array(z.string())]),
}).strict().partial();

export const ZodBrandMeta = z.object({
  name: z.union([
    z.string(),
    z.object({ full: z.string(), short: z.string() }).passthrough().partial(),
  ]),
  link: z.union([
    z.string(),
    z.object({
      home: z.string(),
      mastodon: z.string(),
      bluesky: z.string(),
      github: z.string(),
      linkedin: z.string(),
      twitter: z.string(),
      facebook: z.string(),
    }).passthrough().partial(),
  ]),
}).passthrough().partial();

export const ZodBrandStringLightDark = z.union([
  z.string(),
  z.object({ light: z.string(), dark: z.string() }).strict().partial(),
]);

export const ZodBrandLogoExplicitResource = z.object({
  path: z.string(),
  alt: z.string(),
}).strict().partial().required({ path: true });

export const ZodBrandLogoResource = z.union([
  z.string(),
  z.lazy(() => ZodBrandLogoExplicitResource),
]);

export const ZodBrandLogoSingle = z.object({
  images: z.record(z.lazy(() => ZodBrandLogoResource)).and(
    z.object({}).passthrough().partial(),
  ),
  small: z.string(),
  medium: z.string(),
  large: z.string(),
}).strict().partial();

export const ZodBrandLogoUnified = z.object({
  images: z.record(z.lazy(() => ZodBrandLogoResource)).and(
    z.object({}).passthrough().partial(),
  ),
  small: z.lazy(() => ZodBrandStringLightDark),
  medium: z.lazy(() => ZodBrandStringLightDark),
  large: z.lazy(() => ZodBrandStringLightDark),
}).strict().partial();

export const ZodBrandNamedLogo = z.enum(["small", "medium", "large"] as const);

export const ZodLogoOptions = z.object({ path: z.string(), alt: z.string() })
  .passthrough().partial().required({ path: true });

export const ZodLogoSpecifier = z.union([
  z.string(),
  z.lazy(() => ZodLogoOptions),
]);

export const ZodLogoOptionsPathOptional = z.object({
  path: z.string(),
  alt: z.string(),
}).passthrough().partial();

export const ZodLogoSpecifierPathOptional = z.union([
  z.string(),
  z.lazy(() => ZodLogoOptionsPathOptional),
]);

export const ZodLogoLightDarkSpecifier = z.union([
  z.lazy(() => ZodLogoSpecifier),
  z.object({
    light: z.lazy(() => ZodLogoSpecifier),
    dark: z.lazy(() => ZodLogoSpecifier),
  }).strict().partial(),
]);

export const ZodLogoLightDarkSpecifierPathOptional = z.union([
  z.lazy(() => ZodLogoSpecifierPathOptional),
  z.object({
    light: z.lazy(() => ZodLogoSpecifierPathOptional),
    dark: z.lazy(() => ZodLogoSpecifierPathOptional),
  }).strict().partial(),
]);

export const ZodNormalizedLogoLightDarkSpecifier = z.object({
  light: z.lazy(() => ZodLogoOptions),
  dark: z.lazy(() => ZodLogoOptions),
}).strict().partial();

export const ZodBrandColorValue = z.string();

export const ZodBrandColorSingle = z.object({
  palette: z.record(z.lazy(() => ZodBrandColorValue)).and(
    z.object({}).passthrough().partial(),
  ),
  foreground: z.lazy(() => ZodBrandColorValue),
  background: z.lazy(() => ZodBrandColorValue),
  primary: z.lazy(() => ZodBrandColorValue),
  secondary: z.lazy(() => ZodBrandColorValue),
  tertiary: z.lazy(() => ZodBrandColorValue),
  success: z.lazy(() => ZodBrandColorValue),
  info: z.lazy(() => ZodBrandColorValue),
  warning: z.lazy(() => ZodBrandColorValue),
  danger: z.lazy(() => ZodBrandColorValue),
  light: z.lazy(() => ZodBrandColorValue),
  dark: z.lazy(() => ZodBrandColorValue),
  link: z.lazy(() => ZodBrandColorValue),
}).strict().partial();

export const ZodBrandColorLightDark = z.union([
  z.lazy(() => ZodBrandColorValue),
  z.object({
    light: z.lazy(() => ZodBrandColorValue),
    dark: z.lazy(() => ZodBrandColorValue),
  }).strict().partial(),
]);

export const ZodBrandColorUnified = z.object({
  palette: z.record(z.lazy(() => ZodBrandColorValue)).and(
    z.object({}).passthrough().partial(),
  ),
  foreground: z.lazy(() => ZodBrandColorLightDark),
  background: z.lazy(() => ZodBrandColorLightDark),
  primary: z.lazy(() => ZodBrandColorLightDark),
  secondary: z.lazy(() => ZodBrandColorLightDark),
  tertiary: z.lazy(() => ZodBrandColorLightDark),
  success: z.lazy(() => ZodBrandColorLightDark),
  info: z.lazy(() => ZodBrandColorLightDark),
  warning: z.lazy(() => ZodBrandColorLightDark),
  danger: z.lazy(() => ZodBrandColorLightDark),
  light: z.lazy(() => ZodBrandColorLightDark),
  dark: z.lazy(() => ZodBrandColorLightDark),
  link: z.lazy(() => ZodBrandColorLightDark),
}).strict().partial();

export const ZodBrandMaybeNamedColor = z.union([
  z.lazy(() => ZodBrandNamedThemeColor),
  z.string(),
]);

export const ZodBrandMaybeNamedColorLightDark = z.union([
  z.lazy(() => ZodBrandMaybeNamedColor),
  z.object({
    light: z.lazy(() => ZodBrandMaybeNamedColor),
    dark: z.lazy(() => ZodBrandMaybeNamedColor),
  }).strict().partial(),
]);

export const ZodBrandNamedThemeColor = z.enum(
  [
    "foreground",
    "background",
    "primary",
    "secondary",
    "tertiary",
    "success",
    "info",
    "warning",
    "danger",
    "light",
    "dark",
    "link",
  ] as const,
);

export const ZodBrandTypographySingle = z.object({
  fonts: z.array(z.lazy(() => ZodBrandFont)),
  base: z.lazy(() => ZodBrandTypographyOptionsBase),
  headings: z.lazy(() => ZodBrandTypographyOptionsHeadingsSingle),
  monospace: z.lazy(() => ZodBrandTypographyOptionsMonospaceSingle),
  "monospace-inline": z.lazy(() =>
    ZodBrandTypographyOptionsMonospaceInlineSingle
  ),
  "monospace-block": z.lazy(() =>
    ZodBrandTypographyOptionsMonospaceBlockSingle
  ),
  link: z.lazy(() => ZodBrandTypographyOptionsLinkSingle),
}).strict().partial();

export const ZodBrandTypographyUnified = z.object({
  fonts: z.array(z.lazy(() => ZodBrandFont)),
  base: z.lazy(() => ZodBrandTypographyOptionsBase),
  headings: z.lazy(() => ZodBrandTypographyOptionsHeadingsUnified),
  monospace: z.lazy(() => ZodBrandTypographyOptionsMonospaceUnified),
  "monospace-inline": z.lazy(() =>
    ZodBrandTypographyOptionsMonospaceInlineUnified
  ),
  "monospace-block": z.lazy(() =>
    ZodBrandTypographyOptionsMonospaceBlockUnified
  ),
  link: z.lazy(() => ZodBrandTypographyOptionsLinkUnified),
}).strict().partial();

export const ZodBrandTypographyOptionsBase = z.union([
  z.string(),
  z.object({
    family: z.string(),
    size: z.string(),
    weight: z.lazy(() => ZodBrandFontWeight),
    "line-height": z.lazy(() => ZodLineHeightNumberString),
  }).strict().partial(),
]);

export const ZodBrandTypographyOptionsHeadingsSingle = z.union([
  z.string(),
  z.object({
    family: z.string(),
    weight: z.lazy(() => ZodBrandFontWeight),
    style: z.lazy(() => ZodBrandFontStyle),
    color: z.lazy(() => ZodBrandMaybeNamedColor),
    "line-height": z.lazy(() => ZodLineHeightNumberString),
  }).strict().partial(),
]);

export const ZodBrandTypographyOptionsHeadingsUnified = z.union([
  z.string(),
  z.object({
    family: z.string(),
    weight: z.lazy(() => ZodBrandFontWeight),
    style: z.lazy(() => ZodBrandFontStyle),
    color: z.lazy(() => ZodBrandMaybeNamedColorLightDark),
    "line-height": z.lazy(() => ZodLineHeightNumberString),
  }).strict().partial(),
]);

export const ZodBrandTypographyOptionsMonospaceSingle = z.union([
  z.string(),
  z.object({
    family: z.string(),
    size: z.string(),
    weight: z.lazy(() => ZodBrandFontWeight),
    color: z.lazy(() => ZodBrandMaybeNamedColor),
    "background-color": z.lazy(() => ZodBrandMaybeNamedColor),
  }).strict().partial(),
]);

export const ZodBrandTypographyOptionsMonospaceUnified = z.union([
  z.string(),
  z.object({
    family: z.string(),
    size: z.string(),
    weight: z.lazy(() => ZodBrandFontWeight),
    color: z.lazy(() => ZodBrandMaybeNamedColorLightDark),
    "background-color": z.lazy(() => ZodBrandMaybeNamedColorLightDark),
  }).strict().partial(),
]);

export const ZodBrandTypographyOptionsMonospaceInlineSingle = z.union([
  z.string(),
  z.object({
    family: z.string(),
    size: z.string(),
    weight: z.lazy(() => ZodBrandFontWeight),
    color: z.lazy(() => ZodBrandMaybeNamedColor),
    "background-color": z.lazy(() => ZodBrandMaybeNamedColor),
  }).strict().partial(),
]);

export const ZodBrandTypographyOptionsMonospaceInlineUnified = z.union([
  z.string(),
  z.object({
    family: z.string(),
    size: z.string(),
    weight: z.lazy(() => ZodBrandFontWeight),
    color: z.lazy(() => ZodBrandMaybeNamedColorLightDark),
    "background-color": z.lazy(() => ZodBrandMaybeNamedColorLightDark),
  }).strict().partial(),
]);

export const ZodLineHeightNumberString = z.union([z.number(), z.string()]);

export const ZodBrandTypographyOptionsMonospaceBlockSingle = z.union([
  z.string(),
  z.object({
    family: z.string(),
    size: z.string(),
    weight: z.lazy(() => ZodBrandFontWeight),
    color: z.lazy(() => ZodBrandMaybeNamedColor),
    "background-color": z.lazy(() => ZodBrandMaybeNamedColor),
    "line-height": z.lazy(() => ZodLineHeightNumberString),
  }).strict().partial(),
]);

export const ZodBrandTypographyOptionsMonospaceBlockUnified = z.union([
  z.string(),
  z.object({
    family: z.string(),
    size: z.string(),
    weight: z.lazy(() => ZodBrandFontWeight),
    color: z.lazy(() => ZodBrandMaybeNamedColorLightDark),
    "background-color": z.lazy(() => ZodBrandMaybeNamedColorLightDark),
    "line-height": z.lazy(() => ZodLineHeightNumberString),
  }).strict().partial(),
]);

export const ZodBrandTypographyOptionsLinkSingle = z.union([
  z.string(),
  z.object({
    weight: z.lazy(() => ZodBrandFontWeight),
    color: z.lazy(() => ZodBrandMaybeNamedColor),
    "background-color": z.lazy(() => ZodBrandMaybeNamedColor),
    decoration: z.string(),
  }).strict().partial(),
]);

export const ZodBrandTypographyOptionsLinkUnified = z.union([
  z.string(),
  z.object({
    weight: z.lazy(() => ZodBrandFontWeight),
    color: z.lazy(() => ZodBrandMaybeNamedColorLightDark),
    "background-color": z.lazy(() => ZodBrandMaybeNamedColorLightDark),
    decoration: z.string(),
  }).strict().partial(),
]);

export const ZodBrandNamedTypographyElements = z.enum(
  [
    "base",
    "headings",
    "monospace",
    "monospace-inline",
    "monospace-block",
    "link",
  ] as const,
);

export const ZodBrandFont = z.union([
  z.lazy(() => ZodBrandFontGoogle),
  z.lazy(() => ZodBrandFontBunny),
  z.lazy(() => ZodBrandFontFile),
  z.lazy(() => ZodBrandFontSystem),
]);

export const ZodBrandFontWeight = z.union([
  z.enum(
    [
      "thin",
      "extra-light",
      "ultra-light",
      "light",
      "normal",
      "regular",
      "medium",
      "semi-bold",
      "demi-bold",
      "bold",
      "extra-bold",
      "ultra-bold",
      "black",
    ] as const,
  ),
  z.literal(100),
  z.literal(200),
  z.literal(300),
  z.literal(400),
  z.literal(500),
  z.literal(600),
  z.literal(700),
  z.literal(800),
  z.literal(900),
]);

export const ZodBrandFontStyle = z.enum(
  ["normal", "italic", "oblique"] as const,
);

export const ZodBrandFontCommon = z.object({
  family: z.string(),
  weight: z.union([
    z.lazy(() => ZodBrandFontWeight),
    z.array(z.lazy(() => ZodBrandFontWeight)),
  ]),
  style: z.union([
    z.lazy(() => ZodBrandFontStyle),
    z.array(z.lazy(() => ZodBrandFontStyle)),
  ]),
  display: z.enum(["auto", "block", "swap", "fallback", "optional"] as const),
}).strict().partial();

export const ZodBrandFontSystem = z.object({
  family: z.string(),
  weight: z.union([
    z.lazy(() => ZodBrandFontWeight),
    z.array(z.lazy(() => ZodBrandFontWeight)),
  ]),
  style: z.union([
    z.lazy(() => ZodBrandFontStyle),
    z.array(z.lazy(() => ZodBrandFontStyle)),
  ]),
  display: z.enum(["auto", "block", "swap", "fallback", "optional"] as const),
  source: z.enum(["system"] as const),
}).strict().partial().required({ source: true });

export const ZodBrandFontGoogle = z.object({
  family: z.string(),
  weight: z.union([
    z.lazy(() => ZodBrandFontWeight),
    z.array(z.lazy(() => ZodBrandFontWeight)),
  ]),
  style: z.union([
    z.lazy(() => ZodBrandFontStyle),
    z.array(z.lazy(() => ZodBrandFontStyle)),
  ]),
  display: z.enum(["auto", "block", "swap", "fallback", "optional"] as const),
  source: z.enum(["google"] as const),
}).strict().partial().required({ source: true });

export const ZodBrandFontBunny = z.object({
  family: z.string(),
  weight: z.union([
    z.lazy(() => ZodBrandFontWeight),
    z.array(z.lazy(() => ZodBrandFontWeight)),
  ]),
  style: z.union([
    z.lazy(() => ZodBrandFontStyle),
    z.array(z.lazy(() => ZodBrandFontStyle)),
  ]),
  display: z.enum(["auto", "block", "swap", "fallback", "optional"] as const),
  source: z.enum(["bunny"] as const),
}).strict().partial().required({ source: true });

export const ZodBrandFontFile = z.object({
  source: z.enum(["file"] as const),
  family: z.string(),
  files: z.array(
    z.union([
      z.string(),
      z.object({
        path: z.string(),
        weight: z.lazy(() => ZodBrandFontWeight),
        style: z.lazy(() => ZodBrandFontStyle),
      }).passthrough().partial().required({ path: true }),
    ]),
  ),
}).strict().partial().required({ files: true, family: true, source: true });

export const ZodBrandFontFamily = z.string();

export const ZodBrandSingle = z.object({
  meta: z.lazy(() => ZodBrandMeta),
  logo: z.lazy(() => ZodBrandLogoSingle),
  color: z.lazy(() => ZodBrandColorSingle),
  typography: z.lazy(() => ZodBrandTypographySingle),
  defaults: z.lazy(() => ZodBrandDefaults),
}).strict().partial();

export const ZodBrandUnified = z.object({
  meta: z.lazy(() => ZodBrandMeta),
  logo: z.lazy(() => ZodBrandLogoUnified),
  color: z.lazy(() => ZodBrandColorUnified),
  typography: z.lazy(() => ZodBrandTypographyUnified),
  defaults: z.lazy(() => ZodBrandDefaults),
}).strict().partial();

export const ZodBrandPathOnlyLightDark = z.union([
  z.string(),
  z.object({ light: z.string(), dark: z.string() }).strict().partial(),
]);

export const ZodBrandPathBoolLightDark = z.union([
  z.string(),
  z.boolean(),
  z.object({
    light: z.union([z.string(), z.lazy(() => ZodBrandSingle)]),
    dark: z.union([z.string(), z.lazy(() => ZodBrandSingle)]),
  }).strict().partial(),
  z.lazy(() => ZodBrandUnified),
]);

export const ZodBrandDefaults = z.object({
  bootstrap: z.lazy(() => ZodBrandDefaultsBootstrap),
  quarto: z.object({}).passthrough(),
}).passthrough().partial();

export const ZodBrandDefaultsBootstrap = z.object({
  defaults: z.record(z.union([z.string(), z.boolean(), z.number()])).and(
    z.object({}).passthrough().partial(),
  ),
}).passthrough().partial();

export const ZodProjectConfig = z.object({
  title: z.string(),
  type: z.string(),
  render: z.array(z.string()),
  "execute-dir": z.enum(["file", "project"] as const),
  "output-dir": z.string(),
  "lib-dir": z.string(),
  resources: z.union([z.string(), z.array(z.string())]),
  brand: z.lazy(() => ZodBrandPathOnlyLightDark),
  preview: z.lazy(() => ZodProjectPreview),
  "pre-render": z.union([z.string(), z.array(z.string())]),
  "post-render": z.union([z.string(), z.array(z.string())]),
  detect: z.array(z.array(z.string())),
}).strict().partial();

export const ZodBookProject = z.object({}).passthrough().partial();

export type Date = z.infer<typeof ZodDate>;

export type DateFormat = z.infer<typeof ZodDateFormat>;

export type MathMethods = z.infer<typeof ZodMathMethods>;

export type PandocFormatRequestHeaders = z.infer<
  typeof ZodPandocFormatRequestHeaders
>;

export type PandocFormatOutputFile = z.infer<typeof ZodPandocFormatOutputFile>;

export type PandocFormatFilters = z.infer<typeof ZodPandocFormatFilters>;

export type PandocShortcodes = z.infer<typeof ZodPandocShortcodes>;

export type PageColumn = z.infer<typeof ZodPageColumn>;

export type ContentsAuto = z.infer<typeof ZodContentsAuto>;

/* export type NavigationItem = z.infer<typeof ZodNavigationItem>; */

/* export type NavigationItemObject = z.infer<typeof ZodNavigationItemObject>; */

export type GiscusThemes = z.infer<typeof ZodGiscusThemes>;

export type GiscusConfiguration = z.infer<typeof ZodGiscusConfiguration>;

export type ExternalEngine = z.infer<typeof ZodExternalEngine>;

export type DocumentCommentsConfiguration = z.infer<
  typeof ZodDocumentCommentsConfiguration
>;

export type SocialMetadata = z.infer<typeof ZodSocialMetadata>;

export type PageFooterRegion = z.infer<typeof ZodPageFooterRegion>;

/* export type SidebarContents = z.infer<typeof ZodSidebarContents>; */

export type ProjectPreview = z.infer<typeof ZodProjectPreview>;

export type ProjectServe = z.infer<typeof ZodProjectServe>;

export type Publish = z.infer<typeof ZodPublish>;

export type PublishRecord = z.infer<typeof ZodPublishRecord>;

export type TwitterCardConfig = z.infer<typeof ZodTwitterCardConfig>;

export type OpenGraphConfig = z.infer<typeof ZodOpenGraphConfig>;

export type PageFooter = z.infer<typeof ZodPageFooter>;

export type BaseWebsite = z.infer<typeof ZodBaseWebsite>;

export type BookSchema = z.infer<typeof ZodBookSchema>;

export type ChapterItem = z.infer<typeof ZodChapterItem>;

export type ChapterList = z.infer<typeof ZodChapterList>;

export type OtherLinks = z.infer<typeof ZodOtherLinks>;

export type CrossrefLabelsSchema = z.infer<typeof ZodCrossrefLabelsSchema>;

export type EpubContributor = z.infer<typeof ZodEpubContributor>;

export type FormatLanguage = z.infer<typeof ZodFormatLanguage>;

export type WebsiteAbout = z.infer<typeof ZodWebsiteAbout>;

export type WebsiteListing = z.infer<typeof ZodWebsiteListing>;

export type WebsiteListingContentsObject = z.infer<
  typeof ZodWebsiteListingContentsObject
>;

export type CslDate = z.infer<typeof ZodCslDate>;

export type CslPerson = z.infer<typeof ZodCslPerson>;

export type CslNumber = z.infer<typeof ZodCslNumber>;

export type CslItemShared = z.infer<typeof ZodCslItemShared>;

export type CslItem = z.infer<typeof ZodCslItem>;

export type CitationItem = z.infer<typeof ZodCitationItem>;

export type SmartInclude = z.infer<typeof ZodSmartInclude>;

export type Semver = z.infer<typeof ZodSemver>;

export type QuartoDate = z.infer<typeof ZodQuartoDate>;

export type ProjectProfile = z.infer<typeof ZodProjectProfile>;

export type BadParseSchema = z.infer<typeof ZodBadParseSchema>;

export type QuartoDevSchema = z.infer<typeof ZodQuartoDevSchema>;

export type NotebookViewSchema = z.infer<typeof ZodNotebookViewSchema>;

export type CodeLinksSchema = z.infer<typeof ZodCodeLinksSchema>;

export type ManuscriptSchema = z.infer<typeof ZodManuscriptSchema>;

export type BrandMeta = z.infer<typeof ZodBrandMeta>;

export type BrandStringLightDark = z.infer<typeof ZodBrandStringLightDark>;

export type BrandLogoExplicitResource = z.infer<
  typeof ZodBrandLogoExplicitResource
>;

export type BrandLogoResource = z.infer<typeof ZodBrandLogoResource>;

export type BrandLogoSingle = z.infer<typeof ZodBrandLogoSingle>;

export type BrandLogoUnified = z.infer<typeof ZodBrandLogoUnified>;

export type BrandNamedLogo = z.infer<typeof ZodBrandNamedLogo>;

export type LogoOptions = z.infer<typeof ZodLogoOptions>;

export type LogoSpecifier = z.infer<typeof ZodLogoSpecifier>;

export type LogoOptionsPathOptional = z.infer<
  typeof ZodLogoOptionsPathOptional
>;

export type LogoSpecifierPathOptional = z.infer<
  typeof ZodLogoSpecifierPathOptional
>;

export type LogoLightDarkSpecifier = z.infer<typeof ZodLogoLightDarkSpecifier>;

export type LogoLightDarkSpecifierPathOptional = z.infer<
  typeof ZodLogoLightDarkSpecifierPathOptional
>;

export type NormalizedLogoLightDarkSpecifier = z.infer<
  typeof ZodNormalizedLogoLightDarkSpecifier
>;

export type BrandColorValue = z.infer<typeof ZodBrandColorValue>;

export type BrandColorSingle = z.infer<typeof ZodBrandColorSingle>;

export type BrandColorLightDark = z.infer<typeof ZodBrandColorLightDark>;

export type BrandColorUnified = z.infer<typeof ZodBrandColorUnified>;

export type BrandMaybeNamedColor = z.infer<typeof ZodBrandMaybeNamedColor>;

export type BrandMaybeNamedColorLightDark = z.infer<
  typeof ZodBrandMaybeNamedColorLightDark
>;

export type BrandNamedThemeColor = z.infer<typeof ZodBrandNamedThemeColor>;

export type BrandTypographySingle = z.infer<typeof ZodBrandTypographySingle>;

export type BrandTypographyUnified = z.infer<typeof ZodBrandTypographyUnified>;

export type BrandTypographyOptionsBase = z.infer<
  typeof ZodBrandTypographyOptionsBase
>;

export type BrandTypographyOptionsHeadingsSingle = z.infer<
  typeof ZodBrandTypographyOptionsHeadingsSingle
>;

export type BrandTypographyOptionsHeadingsUnified = z.infer<
  typeof ZodBrandTypographyOptionsHeadingsUnified
>;

export type BrandTypographyOptionsMonospaceSingle = z.infer<
  typeof ZodBrandTypographyOptionsMonospaceSingle
>;

export type BrandTypographyOptionsMonospaceUnified = z.infer<
  typeof ZodBrandTypographyOptionsMonospaceUnified
>;

export type BrandTypographyOptionsMonospaceInlineSingle = z.infer<
  typeof ZodBrandTypographyOptionsMonospaceInlineSingle
>;

export type BrandTypographyOptionsMonospaceInlineUnified = z.infer<
  typeof ZodBrandTypographyOptionsMonospaceInlineUnified
>;

export type LineHeightNumberString = z.infer<typeof ZodLineHeightNumberString>;

export type BrandTypographyOptionsMonospaceBlockSingle = z.infer<
  typeof ZodBrandTypographyOptionsMonospaceBlockSingle
>;

export type BrandTypographyOptionsMonospaceBlockUnified = z.infer<
  typeof ZodBrandTypographyOptionsMonospaceBlockUnified
>;

export type BrandTypographyOptionsLinkSingle = z.infer<
  typeof ZodBrandTypographyOptionsLinkSingle
>;

export type BrandTypographyOptionsLinkUnified = z.infer<
  typeof ZodBrandTypographyOptionsLinkUnified
>;

export type BrandNamedTypographyElements = z.infer<
  typeof ZodBrandNamedTypographyElements
>;

export type BrandFont = z.infer<typeof ZodBrandFont>;

export type BrandFontWeight = z.infer<typeof ZodBrandFontWeight>;

export type BrandFontStyle = z.infer<typeof ZodBrandFontStyle>;

export type BrandFontCommon = z.infer<typeof ZodBrandFontCommon>;

export type BrandFontSystem = z.infer<typeof ZodBrandFontSystem>;

export type BrandFontGoogle = z.infer<typeof ZodBrandFontGoogle>;

export type BrandFontBunny = z.infer<typeof ZodBrandFontBunny>;

export type BrandFontFile = z.infer<typeof ZodBrandFontFile>;

export type BrandFontFamily = z.infer<typeof ZodBrandFontFamily>;

export type BrandSingle = z.infer<typeof ZodBrandSingle>;

export type BrandUnified = z.infer<typeof ZodBrandUnified>;

export type BrandPathOnlyLightDark = z.infer<typeof ZodBrandPathOnlyLightDark>;

export type BrandPathBoolLightDark = z.infer<typeof ZodBrandPathBoolLightDark>;

export type BrandDefaults = z.infer<typeof ZodBrandDefaults>;

export type BrandDefaultsBootstrap = z.infer<typeof ZodBrandDefaultsBootstrap>;

export type ProjectConfig = z.infer<typeof ZodProjectConfig>;

export type BookProject = z.infer<typeof ZodBookProject>;

export const Zod = {
  Date: ZodDate,
  DateFormat: ZodDateFormat,
  MathMethods: ZodMathMethods,
  PandocFormatRequestHeaders: ZodPandocFormatRequestHeaders,
  PandocFormatOutputFile: ZodPandocFormatOutputFile,
  PandocFormatFilters: ZodPandocFormatFilters,
  PandocShortcodes: ZodPandocShortcodes,
  PageColumn: ZodPageColumn,
  ContentsAuto: ZodContentsAuto,
  NavigationItem: ZodNavigationItem,
  NavigationItemObject: ZodNavigationItemObject,
  GiscusThemes: ZodGiscusThemes,
  GiscusConfiguration: ZodGiscusConfiguration,
  ExternalEngine: ZodExternalEngine,
  DocumentCommentsConfiguration: ZodDocumentCommentsConfiguration,
  SocialMetadata: ZodSocialMetadata,
  PageFooterRegion: ZodPageFooterRegion,
  SidebarContents: ZodSidebarContents,
  ProjectPreview: ZodProjectPreview,
  ProjectServe: ZodProjectServe,
  Publish: ZodPublish,
  PublishRecord: ZodPublishRecord,
  TwitterCardConfig: ZodTwitterCardConfig,
  OpenGraphConfig: ZodOpenGraphConfig,
  PageFooter: ZodPageFooter,
  BaseWebsite: ZodBaseWebsite,
  BookSchema: ZodBookSchema,
  ChapterItem: ZodChapterItem,
  ChapterList: ZodChapterList,
  OtherLinks: ZodOtherLinks,
  CrossrefLabelsSchema: ZodCrossrefLabelsSchema,
  EpubContributor: ZodEpubContributor,
  FormatLanguage: ZodFormatLanguage,
  WebsiteAbout: ZodWebsiteAbout,
  WebsiteListing: ZodWebsiteListing,
  WebsiteListingContentsObject: ZodWebsiteListingContentsObject,
  CslDate: ZodCslDate,
  CslPerson: ZodCslPerson,
  CslNumber: ZodCslNumber,
  CslItemShared: ZodCslItemShared,
  CslItem: ZodCslItem,
  CitationItem: ZodCitationItem,
  SmartInclude: ZodSmartInclude,
  Semver: ZodSemver,
  QuartoDate: ZodQuartoDate,
  ProjectProfile: ZodProjectProfile,
  BadParseSchema: ZodBadParseSchema,
  QuartoDevSchema: ZodQuartoDevSchema,
  NotebookViewSchema: ZodNotebookViewSchema,
  CodeLinksSchema: ZodCodeLinksSchema,
  ManuscriptSchema: ZodManuscriptSchema,
  BrandMeta: ZodBrandMeta,
  BrandStringLightDark: ZodBrandStringLightDark,
  BrandLogoExplicitResource: ZodBrandLogoExplicitResource,
  BrandLogoResource: ZodBrandLogoResource,
  BrandLogoSingle: ZodBrandLogoSingle,
  BrandLogoUnified: ZodBrandLogoUnified,
  BrandNamedLogo: ZodBrandNamedLogo,
  LogoOptions: ZodLogoOptions,
  LogoSpecifier: ZodLogoSpecifier,
  LogoOptionsPathOptional: ZodLogoOptionsPathOptional,
  LogoSpecifierPathOptional: ZodLogoSpecifierPathOptional,
  LogoLightDarkSpecifier: ZodLogoLightDarkSpecifier,
  LogoLightDarkSpecifierPathOptional: ZodLogoLightDarkSpecifierPathOptional,
  NormalizedLogoLightDarkSpecifier: ZodNormalizedLogoLightDarkSpecifier,
  BrandColorValue: ZodBrandColorValue,
  BrandColorSingle: ZodBrandColorSingle,
  BrandColorLightDark: ZodBrandColorLightDark,
  BrandColorUnified: ZodBrandColorUnified,
  BrandMaybeNamedColor: ZodBrandMaybeNamedColor,
  BrandMaybeNamedColorLightDark: ZodBrandMaybeNamedColorLightDark,
  BrandNamedThemeColor: ZodBrandNamedThemeColor,
  BrandTypographySingle: ZodBrandTypographySingle,
  BrandTypographyUnified: ZodBrandTypographyUnified,
  BrandTypographyOptionsBase: ZodBrandTypographyOptionsBase,
  BrandTypographyOptionsHeadingsSingle: ZodBrandTypographyOptionsHeadingsSingle,
  BrandTypographyOptionsHeadingsUnified:
    ZodBrandTypographyOptionsHeadingsUnified,
  BrandTypographyOptionsMonospaceSingle:
    ZodBrandTypographyOptionsMonospaceSingle,
  BrandTypographyOptionsMonospaceUnified:
    ZodBrandTypographyOptionsMonospaceUnified,
  BrandTypographyOptionsMonospaceInlineSingle:
    ZodBrandTypographyOptionsMonospaceInlineSingle,
  BrandTypographyOptionsMonospaceInlineUnified:
    ZodBrandTypographyOptionsMonospaceInlineUnified,
  LineHeightNumberString: ZodLineHeightNumberString,
  BrandTypographyOptionsMonospaceBlockSingle:
    ZodBrandTypographyOptionsMonospaceBlockSingle,
  BrandTypographyOptionsMonospaceBlockUnified:
    ZodBrandTypographyOptionsMonospaceBlockUnified,
  BrandTypographyOptionsLinkSingle: ZodBrandTypographyOptionsLinkSingle,
  BrandTypographyOptionsLinkUnified: ZodBrandTypographyOptionsLinkUnified,
  BrandNamedTypographyElements: ZodBrandNamedTypographyElements,
  BrandFont: ZodBrandFont,
  BrandFontWeight: ZodBrandFontWeight,
  BrandFontStyle: ZodBrandFontStyle,
  BrandFontCommon: ZodBrandFontCommon,
  BrandFontSystem: ZodBrandFontSystem,
  BrandFontGoogle: ZodBrandFontGoogle,
  BrandFontBunny: ZodBrandFontBunny,
  BrandFontFile: ZodBrandFontFile,
  BrandFontFamily: ZodBrandFontFamily,
  BrandSingle: ZodBrandSingle,
  BrandUnified: ZodBrandUnified,
  BrandPathOnlyLightDark: ZodBrandPathOnlyLightDark,
  BrandPathBoolLightDark: ZodBrandPathBoolLightDark,
  BrandDefaults: ZodBrandDefaults,
  BrandDefaultsBootstrap: ZodBrandDefaultsBootstrap,
  ProjectConfig: ZodProjectConfig,
  BookProject: ZodBookProject,
};
