// Generated by dts-bundle-generator v9.5.1

/**
 * Core text manipulation types for Quarto
 */
/**
 * Represents a range within a string
 */
interface Range$1 {
	start: number;
	end: number;
}
/**
 * A string with source mapping information
 */
export interface MappedString {
	/**
	 * The text content
	 */
	readonly value: string;
	/**
	 * Optional filename where the content originated
	 */
	readonly fileName?: string;
	/**
	 * Maps positions in this string back to positions in the original source
	 * @param index Position in the current string
	 * @param closest Whether to find the closest mapping if exact is not available
	 */
	readonly map: (index: number, closest?: boolean) => StringMapResult;
}
/**
 * Result of mapping a position in a mapped string
 */
export type StringMapResult = {
	/**
	 * Position in the original source
	 */
	index: number;
	/**
	 * Reference to the original mapped string
	 */
	originalString: MappedString;
} | undefined;
/**
 * String that may be mapped or unmapped
 */
export type EitherString = string | MappedString;
/**
 * Basic metadata types used across Quarto
 */
/**
 * Generic metadata key-value store
 */
export type Metadata = {
	[key: string]: unknown;
};
/**
 * Valid format identifier keys
 */
export type FormatIdentifierKey = "base-format" | "target-format" | "display-name" | "extension-name";
/**
 * Format identifier information
 */
export type FormatIdentifier = {
	[K in FormatIdentifierKey]?: string;
};
/**
 * Format language/localization strings
 */
export interface FormatLanguage {
	[key: string]: string | undefined;
}
/**
 * Complete Format type for engine interfaces
 */
export interface Format {
	/**
	 * Format identifier
	 */
	identifier: FormatIdentifier;
	/**
	 * Format language/localization strings
	 */
	language: FormatLanguage;
	/**
	 * Document metadata
	 */
	metadata: Metadata;
	/**
	 * Format rendering options
	 */
	render: Record<string, unknown>;
	/**
	 * Format execution options
	 */
	execute: Record<string, unknown>;
	/**
	 * Format pandoc options
	 */
	pandoc: {
		to?: string;
		[key: string]: unknown;
	};
}
/**
 * External engine interfaces for Quarto
 */
/**
 * Represents an external engine specified in a project
 */
export interface ExternalEngine {
	/**
	 * Path to the engine implementation
	 */
	path: string;
}
/**
 * Information about a file being processed
 */
export interface FileInformation {
	/**
	 * Full markdown content after expanding includes
	 */
	fullMarkdown?: MappedString;
	/**
	 * Map of file inclusions
	 */
	includeMap?: {
		source: string;
		target: string;
	}[];
	/**
	 * The launched execution engine for this file
	 */
	engine?: ExecutionEngineInstance;
	/**
	 * The execution target for this file
	 */
	target?: ExecutionTarget;
	/**
	 * Document metadata
	 */
	metadata?: Metadata;
}
/**
 * A restricted version of ProjectContext that only exposes
 * functionality needed by execution engines.
 */
export interface EngineProjectContext {
	/**
	 * Base directory of the project
	 */
	dir: string;
	/**
	 * Flag indicating if project consists of a single file
	 */
	isSingleFile: boolean;
	/**
	 * Config object containing project configuration
	 * Used primarily for config?.engines access
	 */
	config?: {
		engines?: (string | ExternalEngine)[];
		project?: {
			outputDir?: string;
		};
	};
	/**
	 * For file information cache management
	 * Used for the transient notebook tracking in Jupyter
	 */
	fileInformationCache: Map<string, FileInformation>;
	/**
	 * Get the output directory for the project
	 *
	 * @returns Path to output directory
	 */
	getOutputDirectory: () => string;
	/**
	 * Resolves full markdown content for a file, including expanding includes
	 *
	 * @param engine - The execution engine
	 * @param file - Path to the file
	 * @param markdown - Optional existing markdown content
	 * @param force - Whether to force re-resolution even if cached
	 * @returns Promise resolving to mapped markdown string
	 */
	resolveFullMarkdownForFile: (engine: ExecutionEngineInstance | undefined, file: string, markdown?: MappedString, force?: boolean) => Promise<MappedString>;
}
/**
 * Minimal type definitions for CLI commands
 */
export interface Command {
	command(name: string, description?: string): Command;
	description(description: string): Command;
	action(fn: (...args: any[]) => void | Promise<void>): Command;
	arguments(args: string): Command;
	option(flags: string, description: string, options?: any): Command;
}
/**
 * Cell type from breaking Quarto markdown
 */
export interface QuartoMdCell {
	id?: string;
	cell_type: {
		language: string;
	} | "markdown" | "raw";
	options?: Record<string, unknown>;
	source: MappedString;
	sourceVerbatim: MappedString;
	sourceWithYaml?: MappedString;
	sourceOffset: number;
	sourceStartLine: number;
	cellStartLine: number;
}
/**
 * Result from breaking Quarto markdown
 */
export interface QuartoMdChunks {
	cells: QuartoMdCell[];
}
/**
 * A partitioned markdown document
 */
export interface PartitionedMarkdown {
	/** YAML frontmatter as parsed metadata */
	yaml?: Metadata;
	/** Text of the first heading */
	headingText?: string;
	/** Attributes of the first heading */
	headingAttr?: {
		id: string;
		classes: string[];
		keyvalue: Array<[
			string,
			string
		]>;
	};
	/** Whether the document contains references */
	containsRefs: boolean;
	/** Complete markdown content */
	markdown: string;
	/** Markdown without YAML frontmatter */
	srcMarkdownNoYaml: string;
}
/**
 * Pandoc types for Quarto
 */
/**
 * Valid Pandoc include locations
 */
export type PandocIncludeLocation = "include-in-header" | "include-before-body" | "include-after-body";
/**
 * Pandoc includes for headers, body, etc.
 * Mapped type that allows any of the valid include locations
 */
export type PandocIncludes = {
	[K in PandocIncludeLocation]?: string[];
};
/**
 * Options for execution
 */
export interface ExecuteOptions {
	/** The execution target */
	target: ExecutionTarget;
	/** Format to render to */
	format: Format;
	/** Directory for resources */
	resourceDir: string;
	/** Directory for temporary files */
	tempDir: string;
	/** Whether to include dependencies */
	dependencies: boolean;
	/** Project directory if applicable */
	projectDir?: string;
	/** Library directory */
	libDir?: string;
	/** Current working directory */
	cwd: string;
	/** Parameters passed to document */
	params?: {
		[key: string]: unknown;
	};
	/** Whether to suppress output */
	quiet?: boolean;
	/** Whether execution is for preview server */
	previewServer?: boolean;
	/** List of languages handled by cell language handlers */
	handledLanguages: string[];
	/** Project context */
	project: EngineProjectContext;
}
/**
 * Result of execution
 */
export interface ExecuteResult {
	/** Resulting markdown content */
	markdown: string;
	/** Supporting files */
	supporting: string[];
	/** Filter scripts */
	filters: string[];
	/** Updated metadata */
	metadata?: Metadata;
	/** Pandoc options */
	pandoc?: Record<string, unknown>;
	/** Pandoc includes */
	includes?: PandocIncludes;
	/** Engine name */
	engine?: string;
	/** Engine-specific dependencies */
	engineDependencies?: Record<string, Array<unknown>>;
	/** Content to preserve during processing */
	preserve?: Record<string, string>;
	/** Whether post-processing is required */
	postProcess?: boolean;
	/** Additional resource files */
	resourceFiles?: string[];
}
/**
 * Options for retrieving dependencies
 */
export interface DependenciesOptions {
	/** The execution target */
	target: ExecutionTarget;
	/** Format to render to */
	format: Format;
	/** Output file path */
	output: string;
	/** Directory for resources */
	resourceDir: string;
	/** Directory for temporary files */
	tempDir: string;
	/** Project directory if applicable */
	projectDir?: string;
	/** Library directory */
	libDir?: string;
	/** Dependencies to include */
	dependencies?: Array<unknown>;
	/** Whether to suppress output */
	quiet?: boolean;
}
/**
 * Result of retrieving dependencies
 */
export interface DependenciesResult {
	/** Pandoc includes */
	includes: PandocIncludes;
}
/**
 * Options for post-processing
 */
export interface PostProcessOptions {
	/** The execution engine */
	engine: ExecutionEngineInstance;
	/** The execution target */
	target: ExecutionTarget;
	/** Format to render to */
	format: Format;
	/** Output file path */
	output: string;
	/** Directory for temporary files */
	tempDir: string;
	/** Project directory if applicable */
	projectDir?: string;
	/** Content to preserve during processing */
	preserve?: Record<string, string>;
	/** Whether to suppress output */
	quiet?: boolean;
}
/**
 * Options for running the engine
 */
export interface RunOptions {
	/** Input file path */
	input: string;
	/** Whether to render */
	render: boolean;
	/** Whether to open in browser */
	browser: boolean;
	/** Directory for temporary files */
	tempDir: string;
	/** Whether to reload */
	reload?: boolean;
	/** Target format */
	format?: string;
	/** Project directory if applicable */
	projectDir?: string;
	/** Port for server */
	port?: number;
	/** Host for server */
	host?: string;
	/** Whether to suppress output */
	quiet?: boolean;
	/** Callback when ready */
	onReady?: () => Promise<void>;
}
/**
 * Jupyter notebook kernelspec
 */
export interface JupyterKernelspec {
	name: string;
	language: string;
	display_name: string;
	path?: string;
}
/**
 * Jupyter language info
 */
export type JupyterLanguageInfo = {
	name: string;
	codemirror_mode?: string | Record<string, unknown>;
	file_extension?: string;
	mimetype?: string;
	pygments_lexer?: string;
};
/**
 * Jupyter notebook cell metadata
 */
export interface JupyterCellMetadata {
	[key: string]: unknown;
}
/**
 * Jupyter notebook output
 */
export interface JupyterOutput {
	output_type: string;
	metadata?: {
		[mimetype: string]: Record<string, unknown>;
	};
	execution_count?: number;
	[key: string]: unknown;
}
/**
 * Jupyter output stream
 */
export interface JupyterOutputStream extends JupyterOutput {
	name: "stdout" | "stderr";
	text: string[] | string;
}
/**
 * Jupyter output display data
 */
export interface JupyterOutputDisplayData extends JupyterOutput {
	data: {
		[mimeType: string]: unknown;
	};
	metadata: {
		[mimeType: string]: Record<string, unknown>;
	};
	noCaption?: boolean;
}
/**
 * Jupyter output figure options
 */
export interface JupyterOutputFigureOptions {
	[key: string]: unknown;
}
/**
 * Jupyter cell options
 */
export interface JupyterCellOptions extends JupyterOutputFigureOptions {
	[key: string]: unknown;
}
/**
 * Jupyter cell with options
 */
export interface JupyterCellWithOptions extends JupyterCell {
	id: string;
	options: JupyterCellOptions;
	optionsSource: string[];
}
/**
 * Jupyter notebook cell
 */
export interface JupyterCell {
	cell_type: "markdown" | "code" | "raw";
	metadata: JupyterCellMetadata;
	source: string | string[];
	id?: string;
	execution_count?: number | null;
	outputs?: JupyterOutput[];
	attachments?: {
		[filename: string]: {
			[mimetype: string]: string | string[];
		};
	};
}
/**
 * Jupyter user expression
 */
export interface JupyterUserExpression {
	expression: string;
	result: JupyterUserExpressionResult;
}
/**
 * Jupyter user expression result
 */
export interface JupyterUserExpressionResult extends JupyterCellOutputData {
	metadata: Metadata;
	status: string;
}
/**
 * Jupyter cell output data
 */
export interface JupyterCellOutputData {
	data: {
		[mimeType: string]: unknown;
	};
}
/**
 * Jupyter cell slideshow
 */
export interface JupyterCellSlideshow {
	[key: string]: string;
}
/**
 * Jupyter notebook structure
 */
export interface JupyterNotebook {
	cells: JupyterCell[];
	metadata: {
		kernelspec: JupyterKernelspec;
		widgets?: Record<string, unknown>;
		language_info?: JupyterLanguageInfo;
		[key: string]: unknown;
	};
	nbformat: number;
	nbformat_minor: number;
}
/**
 * Asset paths for Jupyter notebook output
 */
export interface JupyterNotebookAssetPaths {
	base_dir: string;
	files_dir: string;
	figures_dir: string;
	supporting_dir: string;
}
/**
 * Format execution options
 */
export interface FormatExecute {
	[key: string]: unknown;
}
/**
 * Format render options
 */
export interface FormatRender {
	[key: string]: unknown;
}
/**
 * Format pandoc options
 */
export interface FormatPandoc {
	to?: string;
	[key: string]: unknown;
}
/**
 * Jupyter widget state information
 */
export interface JupyterWidgetsState {
	state: Record<string, unknown>;
	version_major: number;
	version_minor: number;
}
/**
 * Widget dependencies from Jupyter notebook
 */
export interface JupyterWidgetDependencies {
	jsWidgets: boolean;
	jupyterWidgets: boolean;
	htmlLibraries: string[];
	widgetsState?: JupyterWidgetsState;
}
/**
 * Jupyter capabilities
 */
export interface JupyterCapabilities {
	versionMajor: number;
	versionMinor: number;
	versionPatch: number;
	versionStr: string;
	execPrefix: string;
	executable: string;
	conda: boolean;
	pyLauncher: boolean;
	jupyter_core: string | null;
	nbformat: string | null;
	nbclient: string | null;
	ipykernel: string | null;
	shiny: string | null;
}
/**
 * Extended Jupyter capabilities
 */
export interface JupyterCapabilitiesEx extends JupyterCapabilities {
	kernels?: JupyterKernelspec[];
	venv?: boolean;
}
/**
 * Cell output with markdown
 */
export interface JupyterCellOutput {
	id: string;
	markdown: string;
	metadata: Record<string, unknown>;
	options: Record<string, unknown>;
}
/**
 * Options for converting Jupyter notebook to markdown
 */
export interface JupyterToMarkdownOptions {
	executeOptions: ExecuteOptions;
	language: string;
	assets: JupyterNotebookAssetPaths;
	execute: FormatExecute;
	keepHidden?: boolean;
	toHtml: boolean;
	toLatex: boolean;
	toMarkdown: boolean;
	toIpynb: boolean;
	toPresentation: boolean;
	figFormat?: string;
	figDpi?: number;
	figPos?: string;
	preserveCellMetadata?: boolean;
	preserveCodeCellYaml?: boolean;
	outputPrefix?: string;
	fixups?: string | unknown[];
}
/**
 * Options for converting Quarto markdown to Jupyter notebook
 */
export interface QuartoMdToJupyterOptions {
	title?: string;
	format?: Format;
}
/**
 * Result of converting Jupyter notebook to markdown
 */
export interface JupyterToMarkdownResult {
	cellOutputs: JupyterCellOutput[];
	notebookOutputs?: {
		prefix?: string;
		suffix?: string;
	};
	dependencies?: JupyterWidgetDependencies;
	htmlPreserve?: Record<string, string>;
	pandoc?: Record<string, unknown>;
}
/**
 * System and process types for Quarto
 */
/**
 * Process execution result
 */
export interface ProcessResult {
	success: boolean;
	code: number;
	stdout?: string;
	stderr?: string;
}
/**
 * Process execution options
 */
export type ExecProcessOptions = {
	cmd: string;
	args?: string[];
	cwd?: string;
	env?: Record<string, string>;
	stdout?: "piped" | "inherit" | "null";
	stderr?: "piped" | "inherit" | "null";
	stdin?: "piped" | "inherit" | "null";
};
/**
 * Preview server interface
 */
export interface PreviewServer {
	/** Start the server and return the URL to browse to */
	start: () => Promise<string | undefined>;
	/** Run the server (blocking) */
	serve: () => Promise<void>;
	/** Stop the server */
	stop: () => Promise<void>;
}
/**
 * Temporary context for managing temporary files and directories
 */
export interface TempContext {
	/** Base directory for temporary files */
	baseDir: string;
	/** Create a temporary file from string content and return its path */
	createFileFromString: (content: string, options?: {
		suffix?: string;
		prefix?: string;
		dir?: string;
	}) => string;
	/** Create a temporary file and return its path */
	createFile: (options?: {
		suffix?: string;
		prefix?: string;
		dir?: string;
	}) => string;
	/** Create a temporary directory and return its path */
	createDir: (options?: {
		suffix?: string;
		prefix?: string;
		dir?: string;
	}) => string;
	/** Clean up all temporary resources */
	cleanup: () => void;
	/** Register a cleanup handler */
	onCleanup: (handler: VoidFunction) => void;
}
/**
 * Console and UI types for Quarto
 */
/**
 * Options for displaying a spinner in the console
 */
export interface SpinnerOptions {
	/** Message to display with the spinner (or function that returns message) */
	message: string | (() => string);
	/** Message to display when done, or false to hide, or true to keep original message */
	doneMessage?: string | boolean;
}
/**
 * Options for log messages (info, warning, error)
 */
export interface LogMessageOptions {
	/** Whether to add a trailing newline (default: true) */
	newline?: boolean;
	/** Apply bold formatting */
	bold?: boolean;
	/** Apply dim/gray formatting */
	dim?: boolean;
	/** Number of spaces to indent each line */
	indent?: number;
	/** Custom format function applied to each line */
	format?: (line: string) => string;
	/** Enable color formatting (default: true) */
	colorize?: boolean;
	/** Remove ANSI escape codes from output */
	stripAnsiCode?: boolean;
}
/**
 * Render services available during check operations
 * Simplified version containing only what check operations need
 */
export interface CheckRenderServices {
	/** Temporary file management */
	temp: TempContext;
	/** Placeholder for extension context (not used by check) */
	extension?: unknown;
	/** Placeholder for notebook context (not used by check) */
	notebook?: unknown;
}
/**
 * Render services with cleanup capability
 */
export interface CheckRenderServiceWithLifetime extends CheckRenderServices {
	/** Cleanup function to release resources */
	cleanup: () => void;
	/** Optional lifetime management */
	lifetime?: unknown;
}
/**
 * Configuration for check command operations
 * Used by engines implementing checkInstallation()
 */
export interface CheckConfiguration {
	/** Whether to run strict checks */
	strict: boolean;
	/** Target being checked (e.g., "jupyter", "knitr", "all") */
	target: string;
	/** Optional output file path for JSON results */
	output: string | undefined;
	/** Render services (primarily for temp file management) */
	services: CheckRenderServiceWithLifetime;
	/** JSON result object (undefined if not outputting JSON) */
	jsonResult: Record<string, unknown> | undefined;
}
/**
 * Options for test-rendering a document during check operations
 */
export interface CheckRenderOptions {
	/** Markdown content to render */
	content: string;
	/** Language identifier (e.g., "python", "r", "julia") */
	language: string;
	/** Render services for temp file management */
	services: CheckRenderServiceWithLifetime;
}
/**
 * Result of a check render operation
 */
export interface CheckRenderResult {
	/** Whether the render succeeded */
	success: boolean;
	/** Error if render failed */
	error?: Error;
}
/**
 * Global Quarto API interface
 */
export interface QuartoAPI {
	/**
	 * Markdown processing utilities using regex patterns
	 */
	markdownRegex: {
		/**
		 * Extract and parse YAML frontmatter from markdown
		 *
		 * @param markdown - Markdown content with YAML frontmatter
		 * @returns Parsed metadata object
		 */
		extractYaml: (markdown: string) => Metadata;
		/**
		 * Split markdown into components (YAML, heading, content)
		 *
		 * @param markdown - Markdown content
		 * @returns Partitioned markdown with yaml, heading, and content sections
		 */
		partition: (markdown: string) => PartitionedMarkdown;
		/**
		 * Extract programming languages from code blocks
		 *
		 * @param markdown - Markdown content to analyze
		 * @returns Set of language identifiers found in fenced code blocks
		 */
		getLanguages: (markdown: string) => Set<string>;
		/**
		 * Break Quarto markdown into cells
		 *
		 * @param src - Markdown string or MappedString
		 * @param validate - Whether to validate cells (default: false)
		 * @param lenient - Whether to use lenient parsing (default: false)
		 * @returns Promise resolving to chunks with cells
		 */
		breakQuartoMd: (src: string | MappedString, validate?: boolean, lenient?: boolean) => Promise<QuartoMdChunks>;
	};
	/**
	 * MappedString utilities for source location tracking
	 */
	mappedString: {
		/**
		 * Create a mapped string from plain text
		 *
		 * @param text - Text content
		 * @param fileName - Optional filename for source tracking
		 * @returns MappedString with identity mapping
		 */
		fromString: (text: string, fileName?: string) => MappedString;
		/**
		 * Read a file and create a mapped string
		 *
		 * @param path - Path to the file to read
		 * @returns MappedString with file content and source information
		 */
		fromFile: (path: string) => MappedString;
		/**
		 * Normalize newlines while preserving source mapping
		 *
		 * @param markdown - MappedString to normalize
		 * @returns MappedString with \r\n converted to \n
		 */
		normalizeNewlines: (markdown: MappedString) => MappedString;
		/**
		 * Split a MappedString into lines
		 *
		 * @param str - MappedString to split
		 * @param keepNewLines - Whether to keep newline characters (default: false)
		 * @returns Array of MappedStrings, one per line
		 */
		splitLines: (str: MappedString, keepNewLines?: boolean) => MappedString[];
		/**
		 * Convert character offset to line/column coordinates
		 *
		 * @param str - MappedString to query
		 * @param offset - Character offset to convert
		 * @returns Line and column numbers (1-indexed)
		 */
		indexToLineCol: (str: MappedString, offset: number) => {
			line: number;
			column: number;
		};
	};
	/**
	 * Jupyter notebook integration utilities
	 */
	jupyter: {
		/**
		 * Check if a file is a Jupyter notebook
		 *
		 * @param file - File path to check
		 * @returns True if file is a Jupyter notebook (.ipynb)
		 */
		isJupyterNotebook: (file: string) => boolean;
		/**
		 * Check if a file is a Jupyter percent script
		 *
		 * @param file - File path to check
		 * @param extensions - Optional array of extensions to check (default: ['.py', '.jl', '.r'])
		 * @returns True if file is a Jupyter percent script
		 */
		isPercentScript: (file: string, extensions?: string[]) => boolean;
		/**
		 * List of Jupyter notebook file extensions
		 */
		notebookExtensions: string[];
		/**
		 * Extract kernelspec from markdown content
		 *
		 * @param markdown - Markdown content with YAML frontmatter
		 * @returns Extracted kernelspec or undefined if not found
		 */
		kernelspecFromMarkdown: (markdown: string) => JupyterKernelspec | undefined;
		/**
		 * Find a Jupyter kernelspec that supports a given language
		 *
		 * @param language - Language to find kernel for (e.g., "python", "julia", "r")
		 * @returns Promise resolving to matching kernelspec or undefined if not found
		 */
		kernelspecForLanguage: (language: string) => Promise<JupyterKernelspec | undefined>;
		/**
		 * Convert JSON string to Jupyter notebook
		 *
		 * @param nbJson - JSON string containing notebook data
		 * @returns Parsed Jupyter notebook object
		 */
		fromJSON: (nbJson: string) => JupyterNotebook;
		/**
		 * Convert a Jupyter notebook to markdown
		 *
		 * @param nb - Jupyter notebook to convert
		 * @param options - Conversion options
		 * @returns Converted markdown with cell outputs and dependencies
		 */
		toMarkdown: (nb: JupyterNotebook, options: JupyterToMarkdownOptions) => Promise<JupyterToMarkdownResult>;
		/**
		 * Convert Jupyter notebook file to markdown
		 *
		 * @param file - Path to notebook file
		 * @param format - Optional format to use for conversion
		 * @returns Markdown content extracted from notebook
		 */
		markdownFromNotebookFile: (file: string, format?: Format) => string;
		/**
		 * Convert Jupyter notebook JSON to markdown
		 *
		 * @param nbJson - Notebook JSON string
		 * @returns Markdown content extracted from notebook
		 */
		markdownFromNotebookJSON: (nbJson: string) => string;
		/**
		 * Convert a Jupyter percent script to markdown
		 *
		 * @param file - Path to the percent script file
		 * @returns Converted markdown content
		 */
		percentScriptToMarkdown: (file: string) => string;
		/**
		 * Convert Quarto markdown to Jupyter notebook
		 *
		 * @param markdown - Markdown content with YAML frontmatter
		 * @param includeIds - Whether to include cell IDs
		 * @param project - Optional project context for config merging
		 * @returns Promise resolving to Jupyter notebook generated from markdown
		 */
		quartoMdToJupyter: (markdown: string, includeIds: boolean, project?: EngineProjectContext) => Promise<JupyterNotebook>;
		/**
		 * Apply filters to a Jupyter notebook
		 *
		 * @param nb - Jupyter notebook to filter
		 * @param filters - Array of filter strings to apply
		 * @returns Filtered notebook
		 */
		notebookFiltered: (nb: JupyterNotebook, filters: string[]) => JupyterNotebook;
		/**
		 * Create asset paths for Jupyter notebook output
		 *
		 * @param input - Input file path
		 * @param to - Output format (optional)
		 * @returns Asset paths for files, figures, and supporting directories
		 */
		assets: (input: string, to?: string) => JupyterNotebookAssetPaths;
		/**
		 * Generate Pandoc includes for Jupyter widget dependencies
		 *
		 * @param deps - Widget dependencies
		 * @param tempDir - Temporary directory for includes
		 * @returns Pandoc includes structure
		 */
		widgetDependencyIncludes: (deps: JupyterWidgetDependencies, tempDir: string) => PandocIncludes;
		/**
		 * Convert result dependencies to Pandoc includes
		 *
		 * @param tempDir - Temporary directory for includes
		 * @param dependencies - Widget dependencies from execution result
		 * @returns Pandoc includes structure
		 */
		resultIncludes: (tempDir: string, dependencies?: JupyterWidgetDependencies) => PandocIncludes;
		/**
		 * Extract engine dependencies from result dependencies
		 *
		 * @param dependencies - Widget dependencies from execution result
		 * @returns Array of widget dependencies or undefined
		 */
		resultEngineDependencies: (dependencies?: JupyterWidgetDependencies) => Array<JupyterWidgetDependencies> | undefined;
		/**
		 * Get Python executable command
		 *
		 * @param python - Optional Python executable override
		 * @returns Promise resolving to array of command line arguments
		 */
		pythonExec: (python?: string) => Promise<string[]>;
		/**
		 * Get Jupyter capabilities
		 *
		 * @param python - Optional Python executable override
		 * @param jupyter - Optional Jupyter executable override
		 * @returns Promise resolving to Jupyter capabilities
		 */
		capabilities: (python?: string, jupyter?: string) => Promise<JupyterCapabilities>;
		/**
		 * Generate formatted capabilities message with version, path, jupyter version, and kernels
		 *
		 * @param caps - Jupyter capabilities
		 * @param indent - Optional indentation string (default: "")
		 * @returns Promise resolving to formatted capabilities message with indentation
		 */
		capabilitiesMessage: (caps: JupyterCapabilities, indent?: string) => Promise<string>;
		/**
		 * Generate capabilities with kernels list for JSON output
		 *
		 * Enriches capabilities with full kernels array for structured output.
		 * Used by check command JSON output.
		 *
		 * @param caps - Jupyter capabilities
		 * @returns Promise resolving to capabilities with kernels array
		 */
		capabilitiesJson: (caps: JupyterCapabilities) => Promise<JupyterCapabilities & {
			kernels: JupyterKernelspec[];
		}>;
		/**
		 * Generate Jupyter installation instructions
		 *
		 * @param caps - Jupyter capabilities (to determine conda vs pip)
		 * @param indent - Optional indentation string (default: "")
		 * @returns Installation message with appropriate package manager
		 */
		installationMessage: (caps: JupyterCapabilities, indent?: string) => string;
		/**
		 * Check for and generate warning about unactivated Python environments
		 *
		 * @param caps - Jupyter capabilities (to check if python is from venv)
		 * @param indent - Optional indentation string (default: "")
		 * @returns Warning message if unactivated env found, undefined otherwise
		 */
		unactivatedEnvMessage: (caps: JupyterCapabilities, indent?: string) => string | undefined;
		/**
		 * Generate Python installation instructions
		 *
		 * @param indent - Optional indentation string (default: "")
		 * @returns Installation message
		 */
		pythonInstallationMessage: (indent?: string) => string;
	};
	/**
	 * Format detection utilities
	 */
	format: {
		/**
		 * Check if format is HTML compatible
		 *
		 * @param format - Format to check
		 * @returns True if format is HTML compatible
		 */
		isHtmlCompatible: (format: Format) => boolean;
		/**
		 * Check if format is Jupyter notebook output
		 *
		 * @param format - Format pandoc options to check
		 * @returns True if format is ipynb
		 */
		isIpynbOutput: (format: FormatPandoc) => boolean;
		/**
		 * Check if format is LaTeX output
		 *
		 * @param format - Format pandoc options to check
		 * @returns True if format is LaTeX (pdf, latex, or beamer)
		 */
		isLatexOutput: (format: FormatPandoc) => boolean;
		/**
		 * Check if format is markdown output
		 *
		 * @param format - Format to check
		 * @param flavors - Optional array of markdown flavors to check
		 * @returns True if format is markdown
		 */
		isMarkdownOutput: (format: Format, flavors?: string[]) => boolean;
		/**
		 * Check if format is presentation output
		 *
		 * @param format - Format pandoc options to check
		 * @returns True if format is a presentation format
		 */
		isPresentationOutput: (format: FormatPandoc) => boolean;
		/**
		 * Check if format is HTML dashboard output
		 *
		 * @param format - Optional format string to check
		 * @returns True if format is a dashboard
		 */
		isHtmlDashboardOutput: (format?: string) => boolean;
		/**
		 * Check if format is a Shiny server document
		 *
		 * @param format - Optional format to check
		 * @returns True if format has server: shiny
		 */
		isServerShiny: (format?: Format) => boolean;
		/**
		 * Check if format is a Python Shiny server document with Jupyter engine
		 *
		 * @param format - Format to check
		 * @param engine - Execution engine name
		 * @returns True if format is server: shiny with jupyter engine
		 */
		isServerShinyPython: (format: Format, engine: string | undefined) => boolean;
	};
	/**
	 * Path manipulation utilities
	 */
	path: {
		/**
		 * Convert path to absolute form with platform-specific handling
		 *
		 * Handles URL to file path conversion, makes relative paths absolute,
		 * normalizes the path, and uppercases Windows drive letters.
		 *
		 * @param path - Path string or URL to make absolute
		 * @returns Absolute, normalized path with Windows-specific fixes
		 */
		absolute: (path: string | URL) => string;
		/**
		 * Convert path to use forward slashes
		 *
		 * @param path - Path with backslashes or forward slashes
		 * @returns Path with only forward slashes
		 */
		toForwardSlashes: (path: string) => string;
		/**
		 * Get platform-specific runtime directory for Quarto
		 *
		 * Returns the appropriate runtime/state directory based on platform:
		 * - macOS: ~/Library/Caches/quarto/{subdir}
		 * - Windows: %LOCALAPPDATA%/quarto/{subdir}
		 * - Linux: $XDG_RUNTIME_DIR or ~/.local/share/quarto/{subdir}
		 *
		 * Automatically creates the directory if it doesn't exist.
		 *
		 * @param subdir - Optional subdirectory within the runtime directory
		 * @returns Absolute path to the runtime directory
		 */
		runtime: (subdir?: string) => string;
		/**
		 * Get path to a Quarto resource file
		 *
		 * Returns the path to bundled resource files in Quarto's share directory.
		 * Can accept multiple path segments that will be joined.
		 *
		 * @param parts - Path segments to join (e.g., "julia", "script.jl")
		 * @returns Absolute path to the resource file
		 */
		resource: (...parts: string[]) => string;
		/**
		 * Split a file path into directory and stem (filename without extension)
		 *
		 * @param file - File path to split
		 * @returns Tuple of [directory, filename stem]
		 */
		dirAndStem: (file: string) => [
			string,
			string
		];
		/**
		 * Check if a file is a Quarto markdown file (.qmd)
		 *
		 * @param file - File path to check
		 * @returns True if file has .qmd extension
		 */
		isQmdFile: (file: string) => boolean;
		/**
		 * Get the standard supporting files directory name for an input file
		 *
		 * Returns the conventional `{stem}_files` directory name where Quarto
		 * stores supporting resources (images, data files, etc.) for a document.
		 *
		 * @param input - Input file path
		 * @returns Directory name in format `{stem}_files`
		 * @example
		 * ```typescript
		 * inputFilesDir("/path/to/document.qmd") // returns "document_files"
		 * ```
		 */
		inputFilesDir: (input: string) => string;
		/**
		 * Get platform-specific user data directory for Quarto
		 *
		 * Returns the appropriate data directory based on platform:
		 * - macOS: ~/Library/Application Support/quarto/{subdir}
		 * - Windows: %LOCALAPPDATA%/quarto/{subdir} (or %APPDATA% if roaming)
		 * - Linux: $XDG_DATA_HOME/quarto/{subdir} or ~/.local/share/quarto/{subdir}
		 *
		 * Automatically creates the directory if it doesn't exist.
		 *
		 * @param subdir - Optional subdirectory within the data directory
		 * @param roaming - Optional flag for Windows roaming profile (default: false)
		 * @returns Absolute path to the data directory
		 */
		dataDir: (subdir?: string, roaming?: boolean) => string;
	};
	/**
	 * System and environment detection utilities
	 */
	system: {
		/**
		 * Check if running in an interactive session
		 *
		 * Detects if Quarto is running in an interactive environment such as:
		 * - RStudio IDE
		 * - VS Code output channel
		 * - Interactive terminal (TTY)
		 *
		 * @returns True if running in an interactive environment
		 */
		isInteractiveSession: () => boolean;
		/**
		 * Check if running in a CI/CD environment
		 *
		 * Detects if Quarto is running in a continuous integration environment by checking
		 * for common CI environment variables across 40+ CI/CD platforms including:
		 * - GitHub Actions
		 * - GitLab CI
		 * - Jenkins
		 * - CircleCI
		 * - Travis CI
		 * - And many more
		 *
		 * @returns True if running in a CI/CD environment
		 */
		runningInCI: () => boolean;
		/**
		 * Execute an external process
		 *
		 * @param options - Process execution options
		 * @param stdin - Optional stdin content
		 * @param mergeOutput - Optional output stream merging
		 * @param stderrFilter - Optional stderr filter function
		 * @param respectStreams - Optional flag to respect stream separation
		 * @param timeout - Optional timeout in milliseconds
		 * @returns Promise resolving to process result
		 */
		execProcess: (options: ExecProcessOptions, stdin?: string, mergeOutput?: "stderr>stdout" | "stdout>stderr", stderrFilter?: (output: string) => string, respectStreams?: boolean, timeout?: number) => Promise<ProcessResult>;
		/**
		 * Run an external preview server
		 *
		 * @param options - Server options including command and ready pattern
		 * @returns PreviewServer instance for managing the server lifecycle
		 */
		runExternalPreviewServer: (options: {
			cmd: string[];
			readyPattern: RegExp;
			env?: Record<string, string>;
			cwd?: string;
		}) => PreviewServer;
		/**
		 * Register a cleanup handler to run on process exit
		 *
		 * @param handler - Function to run on cleanup (can be async)
		 */
		onCleanup: (handler: () => void | Promise<void>) => void;
		/**
		 * Get global temporary context for managing temporary files and directories
		 *
		 * @returns Global TempContext instance
		 */
		tempContext: () => TempContext;
		/**
		 * Test-render a document for validation during check operations
		 *
		 * Creates a temporary file with the provided content, renders it with
		 * appropriate engine settings, and returns success/failure status.
		 * Used by checkInstallation implementations to verify engines work.
		 *
		 * @param options - Check render options with content and services
		 * @returns Promise resolving to render result with success status
		 */
		checkRender: (options: CheckRenderOptions) => Promise<CheckRenderResult>;
	};
	/**
	 * Text processing utilities
	 */
	text: {
		/**
		 * Split text into lines
		 *
		 * @param text - Text to split
		 * @returns Array of lines
		 */
		lines: (text: string) => string[];
		/**
		 * Trim empty lines from array
		 *
		 * @param lines - Array of lines
		 * @param trim - Which empty lines to trim (default: "all")
		 * @returns Trimmed array of lines
		 */
		trimEmptyLines: (lines: string[], trim?: "leading" | "trailing" | "all") => string[];
		/**
		 * Restore preserved HTML in post-processing
		 *
		 * @param options - Post-processing options including output path and preserve map
		 */
		postProcessRestorePreservedHtml: (options: PostProcessOptions) => void;
		/**
		 * Convert line/column position to character index
		 *
		 * @param text - Text to search in
		 * @returns Function that converts position to index
		 */
		lineColToIndex: (text: string) => (position: {
			line: number;
			column: number;
		}) => number;
		/**
		 * Create a handler for executing inline code
		 *
		 * @param language - Programming language identifier
		 * @param exec - Function to execute code expression
		 * @returns Handler function that processes code strings
		 */
		executeInlineCodeHandler: (language: string, exec: (expr: string) => string | undefined) => (code: string) => string;
		/**
		 * Convert metadata object to YAML text
		 *
		 * @param metadata - Metadata object to convert
		 * @returns YAML formatted string
		 */
		asYamlText: (metadata: Metadata) => string;
	};
	/**
	 * Console and UI utilities
	 */
	console: {
		/**
		 * Execute an async operation with a spinner displayed in the console
		 *
		 * Shows a spinner with a message while the operation runs, then displays
		 * a completion message when done.
		 *
		 * @param options - Spinner display options
		 * @param fn - Async function to execute
		 * @returns Promise resolving to the function's return value
		 */
		withSpinner: <T>(options: SpinnerOptions, fn: () => Promise<T>) => Promise<T>;
		/**
		 * Display a completion message in the console
		 *
		 * Shows a message with a checkmark indicator (or equivalent) to indicate
		 * successful completion of an operation.
		 *
		 * @param message - Message to display
		 */
		completeMessage: (message: string) => void;
		/**
		 * Log an informational message to stderr
		 *
		 * Writes an info-level message to stderr using Quarto's custom logging handler.
		 * Supports formatting options like indentation, bold text, and color control.
		 *
		 * @param message - Message to log
		 * @param options - Optional formatting options
		 */
		info: (message: string, options?: LogMessageOptions) => void;
		/**
		 * Log a warning message to stderr
		 *
		 * Writes a warning-level message to stderr with yellow color and "WARNING:" prefix.
		 * Uses Quarto's custom logging handler.
		 *
		 * @param message - Warning message to log
		 * @param options - Optional formatting options
		 */
		warning: (message: string, options?: LogMessageOptions) => void;
		/**
		 * Log an error message to stderr
		 *
		 * Writes an error-level message to stderr with bright red color and "ERROR:" prefix.
		 * Uses Quarto's custom logging handler.
		 *
		 * @param message - Error message to log
		 * @param options - Optional formatting options
		 */
		error: (message: string, options?: LogMessageOptions) => void;
	};
	/**
	 * Cryptographic utilities
	 */
	crypto: {
		/**
		 * Generate MD5 hash of content
		 *
		 * @param content - String content to hash
		 * @returns MD5 hash as hexadecimal string
		 */
		md5Hash: (content: string) => string;
	};
}
/**
 * Global Quarto API object
 */
export declare const quartoAPI: QuartoAPI;
/**
 * Render flags (extends pandoc flags)
 */
export interface RenderFlags {
	outputDir?: string;
	siteUrl?: string;
	executeDir?: string;
	execute?: boolean;
	executeCache?: true | false | "refresh";
	executeDaemon?: number;
	executeDaemonRestart?: boolean;
	executeDebug?: boolean;
	useFreezer?: boolean;
	metadata?: {
		[key: string]: unknown;
	};
	pandocMetadata?: {
		[key: string]: unknown;
	};
	params?: {
		[key: string]: unknown;
	};
	paramsFile?: string;
	clean?: boolean;
	debug?: boolean;
	quiet?: boolean;
	version?: string;
	to?: string;
	output?: string;
	[key: string]: unknown;
}
/**
 * Render options (simplified)
 * Note: The internal Quarto version includes a 'services' field with
 * RenderServices, which has been omitted as it requires internal dependencies.
 */
export interface RenderOptions {
	flags?: RenderFlags;
	pandocArgs?: string[];
	progress?: boolean;
	useFreezer?: boolean;
	devServerReload?: boolean;
	previewServer?: boolean;
	setProjectDir?: boolean;
	forceClean?: boolean;
	echo?: boolean;
	warning?: boolean;
	quietPandoc?: boolean;
}
/**
 * Result file from rendering
 */
export interface RenderResultFile {
	/** Input file path */
	input: string;
	/** Markdown content */
	markdown: string;
	/** Format used for rendering */
	format: Format;
	/** Output file path */
	file: string;
	/** Whether this is a transient file */
	isTransient?: boolean;
	/** Supporting files generated */
	supporting?: string[];
	/** Resource files */
	resourceFiles: string[];
	/** Whether this is a supplemental file */
	supplemental?: boolean;
}
/**
 * Execution target (filename and context)
 */
export interface ExecutionTarget {
	/** Original source file */
	source: string;
	/** Input file after preprocessing */
	input: string;
	/** Markdown content */
	markdown: MappedString;
	/** Document metadata */
	metadata: Metadata;
	/** Optional target-specific data */
	data?: unknown;
}
/**
 * Interface for execution engine discovery
 * Responsible for the static aspects of engine discovery (not requiring project context)
 */
export interface ExecutionEngineDiscovery {
	/**
	 * Initialize the engine with the Quarto API (optional)
	 * May be called multiple times but always with the same QuartoAPI object.
	 * Engines should store the reference to use throughout their lifecycle.
	 *
	 * @param quarto - The Quarto API for accessing utilities
	 */
	init?: (quarto: QuartoAPI) => void;
	/**
	 * Name of the engine
	 */
	name: string;
	/**
	 * Default extension for files using this engine
	 */
	defaultExt: string;
	/**
	 * Generate default YAML for this engine
	 */
	defaultYaml: (kernel?: string) => string[];
	/**
	 * Generate default content for this engine
	 */
	defaultContent: (kernel?: string) => string[];
	/**
	 * List of file extensions this engine supports
	 */
	validExtensions: () => string[];
	/**
	 * Whether this engine can handle the given file
	 *
	 * @param file - The file path to check
	 * @param ext - The file extension
	 * @returns True if this engine can handle the file
	 */
	claimsFile: (file: string, ext: string) => boolean;
	/**
	 * Whether this engine can handle the given language
	 */
	claimsLanguage: (language: string) => boolean;
	/**
	 * Whether this engine supports freezing
	 */
	canFreeze: boolean;
	/**
	 * Whether this engine generates figures
	 */
	generatesFigures: boolean;
	/**
	 * Directories to ignore during processing (optional)
	 */
	ignoreDirs?: () => string[] | undefined;
	/**
	 * Semver range specifying the minimum required Quarto version for this engine
	 * Examples: ">= 1.6.0", "^1.5.0", "1.*"
	 *
	 * When specified, Quarto will check at engine registration time whether the
	 * current version satisfies this requirement. If not, an error will be thrown.
	 */
	quartoRequired?: string;
	/**
	 * Populate engine-specific CLI commands (optional)
	 * Called at module initialization to register commands like 'quarto enginename status'
	 *
	 * @param command - The CLI command to populate with subcommands
	 */
	populateCommand?: (command: Command) => void;
	/**
	 * Check installation and capabilities for this engine (optional)
	 * Used by `quarto check <engine-name>` command
	 *
	 * Engines implementing this method will automatically be available as targets
	 * for the check command (e.g., `quarto check jupyter`, `quarto check knitr`).
	 *
	 * @param conf - Check configuration with output settings and services
	 */
	checkInstallation?: (conf: CheckConfiguration) => Promise<void>;
	/**
	 * Launch a dynamic execution engine with project context
	 * This is called when the engine is needed for execution
	 *
	 * @param context The restricted project context
	 * @returns ExecutionEngineInstance that can execute documents
	 */
	launch: (context: EngineProjectContext) => ExecutionEngineInstance;
}
/**
 * Interface for a launched execution engine
 * This represents an engine that has been instantiated with a project context
 * and is ready to execute documents
 */
export interface ExecutionEngineInstance {
	/**
	 * Name of the engine
	 */
	name: string;
	/**
	 * Whether this engine supports freezing
	 */
	canFreeze: boolean;
	/**
	 * Get the markdown content for a file
	 */
	markdownForFile(file: string): Promise<MappedString>;
	/**
	 * Create an execution target for the given file
	 */
	target: (file: string, quiet?: boolean, markdown?: MappedString) => Promise<ExecutionTarget | undefined>;
	/**
	 * Get a partitioned view of the markdown
	 */
	partitionedMarkdown: (file: string, format?: Format) => Promise<PartitionedMarkdown>;
	/**
	 * Filter the format based on engine requirements
	 */
	filterFormat?: (source: string, options: RenderOptions, format: Format) => Format;
	/**
	 * Execute the target
	 */
	execute: (options: ExecuteOptions) => Promise<ExecuteResult>;
	/**
	 * Handle skipped execution targets
	 */
	executeTargetSkipped?: (target: ExecutionTarget, format: Format) => void;
	/**
	 * Get dependencies for the target
	 */
	dependencies: (options: DependenciesOptions) => Promise<DependenciesResult>;
	/**
	 * Post-process the execution result
	 */
	postprocess: (options: PostProcessOptions) => Promise<void>;
	/**
	 * Whether this engine can keep source for this target
	 */
	canKeepSource?: (target: ExecutionTarget) => boolean;
	/**
	 * Get a list of intermediate files generated by this engine
	 */
	intermediateFiles?: (input: string) => string[] | undefined;
	/**
	 * Run the engine (for interactivity)
	 */
	run?: (options: RunOptions) => Promise<void>;
	/**
	 * Post-render processing
	 */
	postRender?: (file: RenderResultFile) => Promise<void>;
}

export {
	Range$1 as Range,
};

export {};
