// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
export function jsonFormatter(logRecord) {
  return JSON.stringify({
    level: logRecord.levelName,
    datetime: logRecord.datetime.getTime(),
    message: logRecord.msg,
    args: flattenArgs(logRecord.args)
  });
}
function flattenArgs(args) {
  if (args.length === 1) {
    return args[0];
  } else if (args.length > 1) {
    return args;
  }
}
export const formatters = {
  jsonFormatter
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh0dHBzOi8vanNyLmlvL0BzdGQvbG9nLzAuMjI0LjcvZm9ybWF0dGVycy50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgMjAxOC0yMDI0IHRoZSBEZW5vIGF1dGhvcnMuIEFsbCByaWdodHMgcmVzZXJ2ZWQuIE1JVCBsaWNlbnNlLlxuLy8gVGhpcyBtb2R1bGUgaXMgYnJvd3NlciBjb21wYXRpYmxlLlxuaW1wb3J0IHR5cGUgeyBMb2dSZWNvcmQgfSBmcm9tIFwiLi9sb2dnZXIudHNcIjtcblxuZXhwb3J0IGZ1bmN0aW9uIGpzb25Gb3JtYXR0ZXIobG9nUmVjb3JkOiBMb2dSZWNvcmQpOiBzdHJpbmcge1xuICByZXR1cm4gSlNPTi5zdHJpbmdpZnkoe1xuICAgIGxldmVsOiBsb2dSZWNvcmQubGV2ZWxOYW1lLFxuICAgIGRhdGV0aW1lOiBsb2dSZWNvcmQuZGF0ZXRpbWUuZ2V0VGltZSgpLFxuICAgIG1lc3NhZ2U6IGxvZ1JlY29yZC5tc2csXG4gICAgYXJnczogZmxhdHRlbkFyZ3MobG9nUmVjb3JkLmFyZ3MpLFxuICB9KTtcbn1cblxuZnVuY3Rpb24gZmxhdHRlbkFyZ3MoYXJnczogdW5rbm93bltdKTogdW5rbm93biB7XG4gIGlmIChhcmdzLmxlbmd0aCA9PT0gMSkge1xuICAgIHJldHVybiBhcmdzWzBdO1xuICB9IGVsc2UgaWYgKGFyZ3MubGVuZ3RoID4gMSkge1xuICAgIHJldHVybiBhcmdzO1xuICB9XG59XG5cbmV4cG9ydCBjb25zdCBmb3JtYXR0ZXJzOiB7XG4gIGpzb25Gb3JtYXR0ZXIobG9nUmVjb3JkOiBMb2dSZWNvcmQpOiBzdHJpbmc7XG59ID0ge1xuICBqc29uRm9ybWF0dGVyLFxufTtcbiJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSwwRUFBMEU7QUFDMUUscUNBQXFDO0FBR3JDLE9BQU8sU0FBUyxjQUFjLFNBQW9CO0VBQ2hELE9BQU8sS0FBSyxTQUFTLENBQUM7SUFDcEIsT0FBTyxVQUFVLFNBQVM7SUFDMUIsVUFBVSxVQUFVLFFBQVEsQ0FBQyxPQUFPO0lBQ3BDLFNBQVMsVUFBVSxHQUFHO0lBQ3RCLE1BQU0sWUFBWSxVQUFVLElBQUk7RUFDbEM7QUFDRjtBQUVBLFNBQVMsWUFBWSxJQUFlO0VBQ2xDLElBQUksS0FBSyxNQUFNLEtBQUssR0FBRztJQUNyQixPQUFPLElBQUksQ0FBQyxFQUFFO0VBQ2hCLE9BQU8sSUFBSSxLQUFLLE1BQU0sR0FBRyxHQUFHO0lBQzFCLE9BQU87RUFDVDtBQUNGO0FBRUEsT0FBTyxNQUFNLGFBRVQ7RUFDRjtBQUNGLEVBQUUifQ==
// denoCacheMetadata=16438630502729045021,1024306485587270462