// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
function getBeginToken(delimiter) {
  return Array.isArray(delimiter) ? delimiter[0] : delimiter;
}
function getEndToken(delimiter) {
  return Array.isArray(delimiter) ? delimiter[1] : delimiter;
}
function createRegExps(delimiters) {
  const beginPattern = "(" + delimiters.map(getBeginToken).join("|") + ")";
  const pattern = "^(" + "\\ufeff?" + // Maybe byte order mark
  beginPattern + "$([\\s\\S]+?)" + "^(?:" + delimiters.map(getEndToken).join("|") + ")\\s*" + "$" + (globalThis?.Deno?.build?.os === "windows" ? "\\r?" : "") + "(?:\\n)?)";
  return [
    new RegExp("^" + beginPattern + "$", "im"),
    new RegExp(pattern, "im")
  ];
}
const [RECOGNIZE_YAML_REGEXP, EXTRACT_YAML_REGEXP] = createRegExps([
  [
    "---yaml",
    "---"
  ],
  "= yaml =",
  "---"
]);
const [RECOGNIZE_TOML_REGEXP, EXTRACT_TOML_REGEXP] = createRegExps([
  [
    "---toml",
    "---"
  ],
  "\\+\\+\\+",
  "= toml ="
]);
const [RECOGNIZE_JSON_REGEXP, EXTRACT_JSON_REGEXP] = createRegExps([
  [
    "---json",
    "---"
  ],
  "= json ="
]);
export const RECOGNIZE_REGEXP_MAP = {
  yaml: RECOGNIZE_YAML_REGEXP,
  toml: RECOGNIZE_TOML_REGEXP,
  json: RECOGNIZE_JSON_REGEXP
};
export const EXTRACT_REGEXP_MAP = {
  yaml: EXTRACT_YAML_REGEXP,
  toml: EXTRACT_TOML_REGEXP,
  json: EXTRACT_JSON_REGEXP
};
//# sourceMappingURL=data:application/json;base64,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
// denoCacheMetadata=4871338861880867853,14259427688030605828