// Ported from js-yaml v3.13.1:
// https://github.com/nodeca/js-yaml/commit/665aadda42349dcae869f12040d9b10ef18d12da
// Copyright 2011-2015 by Vitaly Puzrin. All rights reserved. MIT license.
// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
import { CORE_SCHEMA } from "./core.ts";
import { DEFAULT_SCHEMA } from "./default.ts";
import { EXTENDED_SCHEMA } from "./extended.ts";
import { FAILSAFE_SCHEMA } from "./failsafe.ts";
import { JSON_SCHEMA } from "./json.ts";
export { CORE_SCHEMA, DEFAULT_SCHEMA, EXTENDED_SCHEMA, FAILSAFE_SCHEMA, JSON_SCHEMA };
export function replaceSchemaNameWithSchemaClass(options) {
  switch(options?.schema){
    case "core":
      options.schema = CORE_SCHEMA;
      break;
    case "default":
      options.schema = DEFAULT_SCHEMA;
      break;
    case "failsafe":
      options.schema = FAILSAFE_SCHEMA;
      break;
    case "json":
      options.schema = JSON_SCHEMA;
      break;
    case "extended":
      options.schema = EXTENDED_SCHEMA;
      break;
  }
}
//# sourceMappingURL=data:application/json;base64,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
// denoCacheMetadata=18264495017821339521,17609947571003301786