// Ported from js-yaml v3.13.1:
// https://github.com/nodeca/js-yaml/commit/665aadda42349dcae869f12040d9b10ef18d12da
// Copyright 2011-2015 by Vitaly Puzrin. All rights reserved. MIT license.
// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
import { dump } from "./_dumper/dumper.ts";
import { replaceSchemaNameWithSchemaClass } from "./mod.ts";
/**
 * Serializes `data` as a YAML document.
 *
 * You can disable exceptions by setting the skipInvalid option to true.
 *
 * @example Usage
 * ```ts
 * import { stringify } from "@std/yaml/stringify";
 * import { assertEquals } from "@std/assert/assert-equals";
 *
 * const data = { id: 1, name: "Alice" };
 * const yaml = stringify(data);
 *
 * assertEquals(yaml, "id: 1\nname: Alice\n");
 * ```
 *
 * @param data The data to serialize.
 * @param options The options for serialization.
 * @returns A YAML string.
 */ export function stringify(data, options) {
  replaceSchemaNameWithSchemaClass(options);
  // deno-lint-ignore no-explicit-any
  return dump(data, options);
}
//# sourceMappingURL=data:application/json;base64,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
// denoCacheMetadata=9808898830507857020,14698978264952049066